% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artificial_stand.R
\name{artificial_stand}
\alias{artificial_stand}
\title{Artificial Forest Stand}
\usage{
artificial_stand(
  files,
  n.trees,
  dimension,
  coordinates = NULL,
  sample = TRUE,
  replace = TRUE,
  overlap = NULL,
  rotation = TRUE,
  degrees = NULL,
  n_attempts = 100,
  progress = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{files}{A \code{character} vector describing the file name or path of
the tree point cloud to use. Those files most contain three columns
representing the *XYZ* coordinates of a given point cloud.}

\item{n.trees}{A positive \code{numeric} vector describing the number of
point clouds to use.}

\item{dimension}{A positive \code{numeric} vector of length two describing
the width and length of the future forest stand.}

\item{coordinates}{A \code{data.table} of two columns and with \code{nrows}
equal to \code{n.trees} describing the basal *XYZ* coordinates of the point
clouds in the future stand. If \code{NULL}, it uses random basal
coordinates based on stand dimension. \code{NULL} as default.}

\item{sample}{Logical. If \code{TRUE}, it performs a sample of the \code{files} to determine the order to build the artificial stand. If \code{FALSE}, it use the file order described in \code{files}. \code{TRUE} as default.}

\item{replace}{Logical. If \code{TRUE}, it performs a sample selection with a replacement if \code{sample = TRUE} to determine the order to build the artificial stand. Useful if the \code{n.trees} is lower than \code{length(files)}. \code{TRUE} as default.}

\item{overlap}{A positive \code{numeric} vector between 0 and 100 describing the overlap percentage of a given the tree crowns in the future forest stand. If \code{NULL}, the degree of overlap is not controlled.}

\item{rotation}{Logical. If \code{TRUE}, it performs a rotation in yaw axis of the point cloud. \code{TRUE} as default.}

\item{degrees}{A positive \code{numeric} vector describing the degrees of rotation of the point clouds in the future stand. The \code{length(degree)} should be the same as \code{n.trees}. If \code{NULL}, it creates random degrees of rotation for each \code{n.trees}.}

\item{n_attempts}{A positive \code{numeric} vector of length one describing the number of attempts to provide random \code{coordinates} until a tree met the \code{overlap} criteria.
This needs to be used if \code{coordinate = NULL} and \code{overlap != NULL}. \code{n_attempts = 100} as default.}

\item{progress}{Logical, if \code{TRUE} displays a graphical progress bar. \code{TRUE} as default.}

\item{plot}{Logical. If \code{TRUE}, it provides visual tracking of the distribution of each tree in the artificial stand. This can not be exported as a return object.}

\item{...}{Parameters passed to \code{\link[data.table:fread]{fread}} for the reading of \code{files}.}
}
\value{
A \code{list} which contain a \code{data.table} (Trees) with the information of the point clouds used and their current coordinates in the stand, and another \code{data.table} with that compile all the point clouds used.
}
\description{
Create an artificial forest stand of a given area using tree point clouds.
}
\details{
When \code{coordinates = NULL}, \code{artifical_stand} adds, in sequence,
random coordinates to each \code{files} in the future stand based on the
crown area \code{overlap}. That is, first a tree from \code{files} is
randomly located within the stand \code{dimention}, then a second tree from
\code{files} will be located in the future stand based on the crown area
\code{overlap} from the previous tree, and so on. If during the random
location a given tree does not meet the requirements of \code{overlap}, new
random coordinates will be provided until the requirements are met.

Since \code{artificial_stand} will try to add tree to the stand until the
requirements are met, this could lead to an infinite loop if the stand
\code{dimention} is small or if the trees on \code{files} are large or many
\code{n.trees}. Therefore, the use of \code{n_attempts} is recommended to avoid
this scenario.
}
\examples{
#' #Import an example point cloud
path <- system.file("extdata", "pc_tree.txt", package = "rTLS")

#Creates a stand of 4 trees with 10\% of overlap
files <- rep(path, 4)
artificial_stand(files, n.trees = 4, dimension = c(15, 15), overlap = 10)

#Creates a stand of 4 trees with their locations
location <- data.table(X = c(5, 10, 10, 5), Y = c(5, 5, 10, 10))
artificial_stand(files, n.trees = 4, dimension = c(15, 15), coordinates = location)


}
\seealso{
\code{\link{voxels_counting}}
}
\author{
J. Antonio Guzmán Q.
}
