% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_model.R
\name{report.data.frame}
\alias{report.data.frame}
\title{Report tables of summary data}
\usage{
\method{report}{data.frame}(
  x,
  by = NULL,
  remove.by = FALSE,
  file = NULL,
  type = "word",
  digits = 2,
  digitscat = digits,
  print = TRUE,
  ...
)
}
\arguments{
\item{x}{A data.frame object}

\item{by}{Grouping variable for the report}

\item{remove.by}{Remove grouping variable from the report table?}

\item{file}{Name of the file to export the table}

\item{type}{Format of the file}

\item{digits}{Number of decimal places}

\item{digitscat}{Number of decimal places for categorical variables (if different to digits)}

\item{print}{Should the report table be printed on screen?}

\item{...}{further arguments passed to make_table()}
}
\value{
Returns a summary table of the data in publication-friendly format
}
\description{
Creates a report table ready for publication.
}
\examples{
report(iris)
(reporTable<-report(iris, by="Species"))
class(reporTable)
}
