% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalk.R
\name{is.crosswalk_table}
\alias{is.crosswalk_table}
\alias{crosswalk_table_create}
\title{Validate a crosswalk table}
\usage{
is.crosswalk_table(ctable)

crosswalk_table_create(metadata)
}
\arguments{
\item{ctable}{A table to validate if it is a crosswalk table.}

\item{metadata}{A metadata table created by 
[metadata_create()].}
}
\value{
A tibble with raw crosswalk table. It contains all 
harmonization tasks, but the
target values need to be set by further manipulations.
}
\description{
Create a crosswalk table with the source variable names
and variable labels.
}
\details{
The table contains a \code{var_name_target} and 
\code{val_label_target} column, but
these values need to be set by further manual or 
reproducible harmonization steps.
}
\seealso{
Other metadata functions: 
\code{\link{create_codebook}()},
\code{\link{metadata_create}()},
\code{\link{metadata_survey_create}()}

Other harmonization functions: 
\code{\link{collect_val_labels}()},
\code{\link{crosswalk_surveys}()},
\code{\link{harmonize_na_values}()},
\code{\link{harmonize_survey_values}()},
\code{\link{harmonize_values}()},
\code{\link{harmonize_var_names}()},
\code{\link{label_normalize}()}
}
\concept{harmonization functions}
\concept{metadata functions}
