% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeMatrix.R
\name{writeMatrix}
\alias{writeMatrix}
\title{Export matrix into a commonly used tab-delimited format inside Roche Bioinformatics}
\usage{
writeMatrix(x, file, row.names = TRUE)
}
\arguments{
\item{x}{a matrix}

\item{file}{file to be written to}

\item{row.names}{logical, whether row.names is appended. Default: \code{TRUE}}
}
\value{
No return value, called for side effects (writes to file).
}
\description{
\code{writeMatrix} writes a matrix into a non-quoted, tab-delimited file.
}
\details{
Different from the default behaviour of \code{write.table}, an empty cell is inserted as the header of row names (equivalent to setting \code{col.names} to \code{NA}
}
\examples{
test.mat <- matrix(rnorm(1000), nrow=10)
writeMatrix(test.mat, tempfile())
}
\seealso{
\code{\link{readMatrix}} to read in matrix
}
