% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biosHeatmap.R
\name{biosHeatmap}
\alias{biosHeatmap}
\title{CUSTOMED HEATMAP.2 FOR BIOS USERS}
\usage{
biosHeatmap(
  x,
  Rowv = TRUE,
  Colv = if (symm) "Rowv" else TRUE,
  distfun = dist,
  hclustfun = function(x) hclust(x, method = "ward.D2"),
  dendrogram = c("both", "row", "column", "none"),
  symm = FALSE,
  scale = c("none", "row", "column"),
  na.rm = TRUE,
  revC = identical(Colv, "Rowv"),
  add.expr,
  breaks,
  symbreaks = min(x < 0, na.rm = TRUE) || scale != "none",
  col = "greenred",
  na.color = "darkgray",
  colsep,
  rowsep,
  sepcolor = "white",
  sepwidth = c(0.05, 0.05),
  cellnote,
  notecex = 1,
  notecol = "cyan",
  trace = c("none", "column", "row", "both"),
  tracecol = "cyan",
  hline = median(breaks),
  vline = median(breaks),
  linecol = tracecol,
  margins = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  labRow = NULL,
  labCol = NULL,
  cexMain = NULL,
  cexRow = pmin(1, 0.2 + 1/log10(nr)),
  cexCol = pmin(1, 0.2 + 1/log10(nc)),
  ColSideColors,
  RowSideColors,
  color.key.title = "Color Key",
  key = TRUE,
  keysize = 1.5,
  density.info = c("none", "histogram", "density"),
  denscol = tracecol,
  symkey = min(x < 0, na.rm = TRUE) || symbreaks,
  densadj = 0.25,
  zlim,
  lhei = c(1, 7),
  lwid = c(1, 7),
  lmat = NULL,
  ...
)
}
\arguments{
\item{x}{A matrix}

\item{Rowv}{Logical, whether row-wise dendrogram should be calculated}

\item{Colv}{Logical, whether column-wise dendrogram should be calculated}

\item{distfun}{Function, for calculating distance}

\item{hclustfun}{Function, for hierarchical clustering. By default, the
\code{ward.D2} method is used.}

\item{dendrogram}{Character, specify which dendrogram to be drawn. Note that
\code{Rowv} and \code{Colv} determines whether dendrograms are calculated
and rows or columns are reordered.}

\item{symm}{Logical. Should the matrix be treated as symmetric}

\item{scale}{Logical, should the matrix be row-scaled}

\item{na.rm}{Logical, should NA values should be omitted}

\item{revC}{Logical, should columns be reversed}

\item{add.expr}{Expression}

\item{breaks}{Numeric vector, where to set breaks. Can be missing.}

\item{symbreaks}{Logical, should be breaks symmetric}

\item{col}{Colors for the heatmap, by default green indicates low and red
indicates high values}

\item{na.color}{Color for \code{NA} cells, darkgray by default}

\item{colsep, rowsep}{Integer vector, positions at which columns or rows are
separated}

\item{sepcolor, sepwidth}{Color and width of separating lines}

\item{cellnote}{Cell labelling}

\item{notecex}{Cell labelling font size}

\item{notecol}{Cell labelling font color}

\item{trace}{Logical , whether drawing tracing lines, by default not}

\item{tracecol}{Level trace}

\item{hline}{Level trace hline}

\item{vline}{Level trace vline}

\item{linecol}{Level trace color}

\item{margins}{Margins of labs, automatically guessed if no value was
provided}

\item{main, xlab, ylab}{Heatmap title, X and Y axis labels}

\item{labRow, labCol}{Row and column labels}

\item{cexMain, cexRow, cexCol}{Title, row and column label font sizes}

\item{ColSideColors, RowSideColors}{Column and row side colors}

\item{color.key.title}{Color key title}

\item{key}{Logical, whether key should be drawn}

\item{keysize}{Key size}

\item{density.info}{Logical, drawing density info in the key histogram, by
default not}

\item{denscol}{Logical, should density information be displayed}

\item{symkey}{Logical, should the key be symmetric}

\item{densadj}{densadj}

\item{zlim}{zlim}

\item{lhei}{Heights of rows}

\item{lwid}{Widths of columns}

\item{lmat}{lmat}

\item{\dots}{Other paramters passed to \code{heatmap.2} function}
}
\value{
See \code{heatmap.2} in the \code{gplots} package.
}
\description{
A tailored version of the \code{heatmap.2} function in the gplots package,
by giving the default values in the paramter list.
}
\details{
Customed version of the heatmap.2, with the common settings used by JItao
David Zhang
}
\examples{

set.seed(123)
test <- matrix(rnorm(100), nrow=10)
biosHeatmap(test)

## do not draw row-wise dendrogram
biosHeatmap(test, Rowv=FALSE, dendrogram="column")
## do not draw column-wise dendrogram
biosHeatmap(test, Colv=FALSE, dendrogram="row")
## do not re-sort columns/rows (e.g. for visualization purposes)
biosHeatmap(test, Rowv=FALSE, Colv=FALSE, dendrogram="none")

## define the color range by zlim
biosHeatmap(test, zlim=c(-5, 5))

}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
