% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airm.R
\name{airm_log}
\alias{airm_log}
\title{Compute the AIRM Logarithm}
\usage{
airm_log(sigma, lambda, validate = FALSE)
}
\arguments{
\item{sigma}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the reference point.}

\item{lambda}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the target point.}

\item{validate}{A logical value indicating whether to validate input arguments. Default is FALSE.}
}
\value{
A symmetric matrix of class \code{dspMatrix}, representing the tangent space image of \code{lambda} at \code{sigma}.
}
\description{
This function computes the Riemannian logarithmic map for the Affine-Invariant Riemannian Metric (AIRM).
}
\examples{
if (requireNamespace("Matrix", quietly = TRUE)) {
  library(Matrix)
  sigma <- diag(2) |>
    Matrix::nearPD() |>
    _$mat |>
    Matrix::pack()
  lambda <- diag(c(2, 3)) |>
    Matrix::nearPD() |>
    _$mat |>
    Matrix::pack()
  airm_log(sigma, lambda)
}
}
