% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dag.R
\name{rxp_visnetwork}
\alias{rxp_visnetwork}
\title{Create a Directed Acyclic Graph (DAG) representing the pipeline
using \code{{visNetwork}}}
\usage{
rxp_visnetwork(
  nodes_and_edges = get_nodes_edges(),
  color_by = c("pipeline", "type"),
  colour_by = NULL
)
}
\arguments{
\item{nodes_and_edges}{List, output of \code{get_nodes_edges()}.}

\item{color_by}{Character, either "pipeline" (default) or "type".
When "pipeline", nodes are colored by their pipeline group (if defined).
When "type", nodes are colored by their derivation type (rxp_r, rxp_py, etc.).}

\item{colour_by}{Character, alias for \code{color_by}.}
}
\value{
Nothing, this function opens a new tab in your browser with
the DAG generated using \code{{visNetwork}}.
}
\description{
Uses \code{{visNetwork}} to generate the plot. \code{{visNetwork}} is a
soft dependency of \code{{rixpress}} so you need to install it to use this
function. When derivations are organized into pipelines using
\code{rxp_pipeline()}, nodes are colored according to their pipeline colors
and grouped by pipeline name in the legend.
}
\examples{
\dontrun{
  rxp_visnetwork()
  rxp_visnetwork(color_by = "type")  # Color by derivation type instead
}
}
\seealso{
Other visualisation functions: 
\code{\link{rxp_ggdag}()}
}
\concept{visualisation functions}
