/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockStorage;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class MatrixStorage {
    private double[] m_data;
    private int m_n;
    private int m_nused;
    private final int m_size;
    private final int m_nr;
    private int m_nc;

    public MatrixStorage(int dim, int capacity) {
        this.m_n = DataBlockStorage.calcSize(capacity);
        this.m_nr = this.m_nc = dim;
        this.m_size = dim * dim;
        this.m_data = new double[this.m_size * this.m_n];
    }

    public MatrixStorage(int nr, int nc, int capacity) {
        this.m_n = DataBlockStorage.calcSize(capacity);
        this.m_nr = nr;
        this.m_nc = nc;
        this.m_size = nr * nc;
        this.m_data = new double[this.m_size * this.m_n];
    }

    public int getMatrixRowsCount() {
        return this.m_nr;
    }

    public int getMatrixColumnsCount() {
        return this.m_nc;
    }

    public int getCapacity() {
        return this.m_n;
    }

    public int getCurrentSize() {
        return this.m_nused;
    }

    public FastMatrix matrix(int pos) {
        return new FastMatrix(this.m_data, this.m_nr, this.m_size * pos, this.m_nr, this.m_nc);
    }

    public DataBlock item(int row, int col) {
        int start = row + this.m_nr * col;
        int end = start + this.m_nused * this.m_size;
        return DataBlock.of(this.m_data, start, end, this.m_size);
    }

    public void resize(int ncapacity) {
        int n = DataBlockStorage.calcSize(ncapacity);
        if (n <= this.m_n) {
            return;
        }
        double[] data = new double[this.m_size * n];
        System.arraycopy(this.m_data, 0, data, 0, this.m_data.length);
        this.m_data = data;
        this.m_n = n;
    }

    public void save(int pos, FastMatrix m) {
        m.copyTo(this.m_data, pos * this.m_size);
        if (pos >= this.m_nused) {
            this.m_nused = pos + 1;
        }
    }

    public void rescale(double factor) {
        if (factor == 1.0) {
            return;
        }
        int n = this.m_size * this.m_nused;
        int i = 0;
        while (i < n) {
            int n2 = i++;
            this.m_data[n2] = this.m_data[n2] * factor;
        }
    }
}

