/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import lombok.NonNull;

public final class ConcentratedLikelihoodWithMissing
implements ConcentratedLikelihood {
    private final int n;
    private final int nmissing;
    private final double ll;
    private final double ssqerr;
    private final double ldet;
    private final double[] res;
    private final double[] b;
    private final FastMatrix bvar;
    private final boolean scalingFactor;

    public static Builder builder() {
        return new Builder();
    }

    private ConcentratedLikelihoodWithMissing(int n, int nmissing, double ssqerr, double ldet, double[] res, double[] b, FastMatrix bvar, boolean scalingFactor) {
        this.n = n;
        this.nmissing = nmissing;
        this.ldet = ldet;
        this.ssqerr = ssqerr;
        this.b = b;
        this.bvar = bvar;
        this.res = res;
        this.scalingFactor = scalingFactor;
        this.ll = scalingFactor ? -0.5 * ((double)n * Constants.LOGTWOPI + (double)n * (1.0 + Math.log(ssqerr / (double)n)) + ldet) : -0.5 * ((double)n * Constants.LOGTWOPI + ssqerr + ldet);
    }

    public int nmissing() {
        return this.nmissing;
    }

    public DoubleSeq missingCorrections() {
        return this.nmissing == 0 ? Doubles.EMPTY : DoubleSeq.of((double[])this.b, (int)0, (int)this.nmissing);
    }

    public DoubleSeq missingUnscaledVariances() {
        if (this.nmissing == 0) {
            return Doubles.EMPTY;
        }
        return this.bvar.diagonal().extract(0, this.nmissing);
    }

    public DoubleSeq allCoefficients() {
        return DoubleSeq.of((double[])this.b);
    }

    @Override
    public boolean isScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public double logDeterminant() {
        return this.ldet;
    }

    @Override
    public double logLikelihood() {
        return this.ll;
    }

    @Override
    public int dim() {
        return this.n;
    }

    @Override
    public int nx() {
        return this.b.length - this.nmissing;
    }

    @Override
    public DoubleSeq e() {
        return DoubleSeq.of((double[])this.res);
    }

    @Override
    @NonNull
    public DoubleSeq coefficients() {
        return DoubleSeq.of((double[])this.b, (int)this.nmissing, (int)(this.b.length - this.nmissing));
    }

    @Override
    public double coefficient(int pos) {
        return this.b[pos + this.nmissing];
    }

    @Override
    @NonNull
    public FastMatrix unscaledCovariance() {
        if (this.bvar == null) {
            return FastMatrix.EMPTY;
        }
        if (this.nmissing == 0) {
            return this.bvar;
        }
        int nb = this.b.length - this.nmissing;
        return this.bvar.extract(this.nmissing, nb, this.nmissing, nb);
    }

    @Override
    public double ssq() {
        return this.ssqerr;
    }

    public ConcentratedLikelihoodWithMissing rescale(double yfactor, double[] xfactor) {
        double nssqerr = this.ssqerr / (yfactor * yfactor);
        double[] nres = null;
        if (this.res != null) {
            nres = new double[this.res.length];
            for (int i = 0; i < this.res.length; ++i) {
                nres[i] = this.res[i] / yfactor;
            }
        }
        double[] nb = null;
        FastMatrix nbvar = null;
        if (this.b != null) {
            nb = new double[this.b.length];
            if (xfactor == null) {
                for (int i = 0; i < this.b.length; ++i) {
                    nb[i] = this.b[i] / yfactor;
                }
                nbvar = this.bvar;
            } else {
                for (int i = 0; i < this.b.length; ++i) {
                    nb[i] = this.b[i] * xfactor[i] / yfactor;
                }
                FastMatrix tmp = this.bvar.deepClone();
                for (int i = 0; i < this.b.length; ++i) {
                    double ifactor = xfactor[i];
                    for (int j = 0; j < i; ++j) {
                        double ijfactor = ifactor * xfactor[j];
                        tmp.apply(i, j, x -> x * ijfactor);
                        tmp.apply(j, i, x -> x * ijfactor);
                    }
                    tmp.apply(i, i, x -> x * ifactor * ifactor);
                }
                nbvar = tmp;
            }
        }
        double nldet = this.ldet;
        if (!this.scalingFactor) {
            nldet += (double)this.n * Math.log(yfactor);
        }
        return new ConcentratedLikelihoodWithMissing(this.n, this.nmissing, nssqerr, nldet, nres, nb, nbvar, this.scalingFactor);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("log-likelihood: ").append(this.ll).append(", sigma2: ").append(this.ssqerr / (double)this.n);
        return builder.toString();
    }

    public static class Builder {
        private static final double[] B_EMPTY = new double[0];
        private int n;
        private int nmissing = 0;
        private double ssqerr;
        private double ldet;
        private double[] res;
        private double[] b = B_EMPTY;
        private FastMatrix bvar;
        private boolean scalingFactor = true;

        private Builder() {
        }

        public Builder ndata(int n) {
            this.n = n;
            return this;
        }

        public Builder scalingFactor(boolean scalingFactor) {
            this.scalingFactor = scalingFactor;
            return this;
        }

        public Builder nmissing(int nmissing) {
            this.nmissing = nmissing;
            return this;
        }

        public Builder logDeterminant(double ldet) {
            this.ldet = ldet;
            return this;
        }

        public Builder ssqErr(double ssq) {
            this.ssqerr = ssq;
            return this;
        }

        public Builder residuals(DoubleSeq residuals) {
            if (residuals == null) {
                return this;
            }
            if (this.ssqerr == 0.0) {
                this.ssqerr = DoublesMath.ssq((DoubleSeq)residuals);
            }
            this.res = residuals.toArray();
            return this;
        }

        public Builder coefficients(DoubleSeq coeff) {
            if (coeff != null) {
                this.b = coeff.toArray();
            }
            return this;
        }

        public Builder unscaledCovariance(FastMatrix var) {
            this.bvar = var;
            return this;
        }

        public ConcentratedLikelihoodWithMissing build() {
            return new ConcentratedLikelihoodWithMissing(this.n - this.nmissing, this.nmissing, this.ssqerr, this.ldet, this.res, this.b, this.bvar, this.scalingFactor);
        }
    }
}

