% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{sarima_hannan_rissanen}
\alias{sarima_hannan_rissanen}
\title{Estimate ARIMA Model with Hannan-Rissanen method}
\usage{
sarima_hannan_rissanen(
  x,
  order = c(0, 0, 0),
  seasonal = list(order = c(0, 0, 0), period = NA),
  initialization = c("Ols", "Levinson", "Burg"),
  biasCorrection = TRUE,
  finalCorrection = TRUE
)
}
\arguments{
\item{x}{an univariate time series (TS object).}

\item{order}{vector specifying of the non-seasonal part of the ARIMA model:
the AR order, the degree of differencing, and the MA order.}

\item{seasonal}{specification of the seasonal part of the ARIMA model and the
seasonal frequency (by default equals to \code{frequency(x)}).
Either  a list with components \code{order} and \code{period} or a numeric vector
specifying the seasonal order (the default period is then used).}

\item{initialization}{Algorithm used in the computation of the long order
auto-regressive model (used to estimate the innovations)}

\item{biasCorrection}{Bias correction}

\item{finalCorrection}{Final correction as implemented in Tramo}
}
\value{
An object of class \code{JD3_SARIMA} with the estimated coefficient.
}
\description{
Estimate ARIMA Model with Hannan-Rissanen method
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
y <- ABS$X0.2.09.10.M
model<- sarima_hannan_rissanen(y, order = c(0, 1, 1), seasonal = c(0, 1, 1))
\dontshow{\}) # examplesIf}
}
