% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dates.R
\name{road_get_dates}
\alias{road_get_dates}
\title{Retrieve dating information for assemblages, geological and archaeological layers from the ROAD Database}
\usage{
road_get_dates(assemblages = NULL)
}
\arguments{
\item{assemblages}{specifies a data frame with a subset of assemblages, for
which dating information should be retrieved. It must necessarily contain the
columns \code{locality_id} and \code{assemblage_id} (e.g., the output of 
\code{road_get_assemblages()}, or other functions with this level of detail).}
}
\value{
A data frame with absolute dating information. Rows represent individual dates, columns contain standard outputs and dating-related details on:

\code{age}: The attribute specifies the result of the dating analysis as reported by the laboratory in years before present (BP). Note that 14C dates are \strong{uncalibarated}.

\code{negative_standard_deviation} & \code{positive_standard_deviation}: The attributes specify the positive and negative standard deviation of the dating analysis in years.

\code{material_dated}: The attribute specifies the general type of material analyzed (e.g. bone, tooth, antler etc.).

\code{dating_method}: The attribute specifies the method of analysis (e.g. 14C, OSL, IRSL, etc.).

\code{laboratory_idlaboratory}: The attribute is the official abbreviation for the designated analytical laboratory.

\code{analysis_number}: The attribute specifies the official laboratory number 
assigned to the dated sample (e.g., Pta-2345, GrA-1234, OxA-X-2456-45). It always includes 
the lab prefix, followed by a single hyphen, and then the official number provided by the laboratory.

\code{date_of_analysis}: The attribute specifies the year of the analysis/report 
or the first publication of the results in the format yyyy.

\code{id}: The attribute is automatically generated, sequential number. This number is unique for each age table.

\code{publication}: The attribute is a list of publications describing the respective geological stratigraphy.
}
\description{
The \strong{\code{road_get_dates}} function retrieves absolute dating records for 
assemblages, geological layers, and archaeological layers from the ROAD database.
}
\details{
Use the argument to filter search results by assemblage or omit
it to have a broader result set. The argument is optional and should be
omitted or set to NULL when not used.


The function is designed for users analyzing time series and allows for 
filtering results based on various criteria.



\strong{Background on Dating Context:}
Not all finds can be directly dated, either due to potential damage during
sampling or because the materials are unsuitable for absolute dating. In such
cases, the surrounding sediment or other objects—made from more suitable
materials—are dated and associated with the find. As a result, absolute dates
are stored in three different tables within ROAD:
\itemize{
   \item \code{geological_layer_age}: Dates from samples taken from geological layers.
   \item \code{archaeological_layer_age}: Dates from samples taken from archaeological layers.
   \item \code{assemblage_age}: Dates from samples taken directly from objects.
   }

\strong{Background on multiple dates:} Multiple dates may be available for a
single object. For example, both the top and bottom of a stratigraphic unit 
may be sampled to bracket the age of a find. Different dating methods might 
also be used to obtain robust results, which can lead to varying age estimates. 
This is especially true when earlier dating methods are updated with more 
modern techniques. It is recommended to cross-check all results against 
relevant literature. 

\strong{Background on aggregated ages:} The ROCEEH project has developed its 
own model to aggregate both absolute and relative dating methods to derive 
the variables \code{age_min} and \code{age_max}. These aggregated ages are 
not included in the \code{road_get_dates} function, which only returns raw data.

\strong{Background on radiocarbon dating:} Please note that C14 dates are 
uncalibrated. For further analysis, use one of the available calibration 
tools, such as the \pkg{rcarbon} package available on CRAN 
(see: \url{https://cran.r-project.org/package=rcarbon}).

All parameters are optional. If not used, omit them or set them to NULL.
}
\examples{
\donttest{assemblages <- road_get_assemblages(country="Slovenia")}
\donttest{road_get_dates(assemblages)}
}
