% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyserial_efficiency.R
\name{polyserial_efficiency}
\alias{polyserial_efficiency}
\title{Efficiency of minimum DPD estimators of polyserial model}
\usage{
polyserial_efficiency(theta, alpha)
}
\arguments{
\item{theta}{Parameter vector of polyserial model; assumed to be the true one. First element is polyserial correlatio coefficient, second is the population mean of X, third is population variance of X, and the remaining elements are the thresholds associated with the ordnal Y (must be in increasing order)}

\item{alpha}{Tuning constant governing robustness-efficiency tradeoff. Set to 0 for maximum likelihood.}
}
\value{
A numeric matrix that is the population asymptotic variance-covariance matrix associated with a parameter vector \code{theta} and tuning constant \code{alpha}.
}
\description{
Calculate population asymptotic variance-covariance matrix associated with a parameter vector \code{theta}, assuming that the polyserial model is correctly specified and that \code{theta} is the true model parameter. May take a few moments to compute because a relatively large number of integrals need to be numerically solved.
}
\examples{
theta <- c(rho = 0, mu = 0, sigma2 = 1, tau1 = 0) # true parameter vector
polyserial_efficiency(theta, alpha = 0.5)

}
