% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{robust.prioritizr}
\alias{robust.prioritizr}
\alias{robust.prioritizr-package}
\title{robust.prioritizr: Robust Systematic Conservation Prioritization in R}
\description{
The \pkg{robust.prioritizr} R package provides tools for building and solving
robust systematic conservation prioritization problems. It extends the
\pkg{prioritizr} package to account for uncertainty in the input data.
This is particularly useful when working with data that is subject to
change, such as species distribution models under climate change scenarios.
}
\details{
This package contains several vignettes that are designed to
showcase its functionality. To view them, please use the code
\code{vignette("name", package = "robust.prioritizr")} where \code{"name"} is the
name of the desired vignette (e.g., \code{"robust.prioritizr"}).

\describe{

\item{robust.prioritizr}{
Brief introduction to the package.
}

\item{climate-sdm}{
Example using simulated data from a species distribution model.
}

\item{vic-cons-planning}{
Example using Victoria, Australia.
}

}
}
\seealso{
Useful links:
\itemize{
\item Package website (\url{https://frankiecho.github.io/robust.prioritizr/})
\item Source code repository (\url{https://github.com/frankiecho/robust.prioritizr})
\item Report bugs (\url{https://github.com/frankiecho/robust.prioritizr/issues})
}
}
\author{
Authors:
\itemize{
\item Frankie Cho \email{frankie.cho@qut.edu.au} (\href{https://orcid.org/0000-0003-1369-4980}{ORCID})
\item Jeffrey O Hanson \email{jeffrey.hanson@uqconnect.edu.au} (\href{https://orcid.org/0000-0002-4716-6134}{ORCID})
}
}
