% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_wDCt.R
\name{compute_wDCt}
\alias{compute_wDCt}
\title{Cleaning data and weighted delta Ct (wDCt) calculation}
\usage{
compute_wDCt(
  x,
  numOfFactors,
  numberOfrefGenes,
  block,
  set_missing_target_Ct_to_40 = FALSE
)
}
\arguments{
\item{x}{A data frame containing experimental design columns, replicates (integer), target gene
E/Ct column pairs, and reference gene E/Ct column pairs. Reference gene
columns must be located at the end of the data frame.}

\item{numOfFactors}{Integer. Number of experimental factor columns
(excluding \code{rep} and optional \code{block}).}

\item{numberOfrefGenes}{Integer. Number of reference genes.}

\item{block}{Character or \code{NULL}. Name of the blocking factor column.
When a qPCR experiment is done in multiple qPCR plates, each plate is considered as a random block 
so that at least one replicate of each treatment and control is present 
on a plate.}

\item{set_missing_target_Ct_to_40}{If \code{TRUE}, missing target gene Ct 
values become 40; if \code{FALSE} (default), they become NA.}
}
\value{
The original data frame along with the weighted delta Ct column.
}
\description{
The \code{compute_wDCt} function cleans the data and computes wDCt. This function is 
automatically applied to the expression analysis functions like \code{ANOVA_DDCt}, 
\code{TTEST_DDCt}, etc. So it should not be applied in advance of expression analysis functions.
}
\details{
The \code{compute_wDCt} function computes weighted delta Ct (wDCt) for the input data. 
Missing data can be denoted by NA in the input data frame. 
Values such as '0' and 'undetermined' (for any E and Ct) are
automatically converted to NA. For target genes, NA for E or Ct measurements cause returning NA for 
the corresponding delta Ct for that replicate (row). 
If there are more than one reference gene, NA in the place of the E or the Ct value cause
skipping that gene and remaining references are geometrically averaged.
The \code{compute_wDCt} function is automatically applied to the expression analysis
functions.
}
\examples{
           
data <- read.csv(system.file("extdata", "data_2factorBlock3ref.csv", package = "rtpcr"))
data
compute_wDCt(x = data,
             numOfFactors = 2,
             numberOfrefGenes = 3,
             block = "block")

}
