% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-string.R
\name{sas_run_string}
\alias{sas_run_string}
\title{Execute SAS code string}
\usage{
sas_run_string(input, capture = "both", height = "auto", width = "auto")
}
\arguments{
\item{input}{string; SAS code to run.}

\item{capture}{string; If \code{"both"}, tabpanel with output and log included. If
\code{"listing"}, only output is included. If \code{"log"} only log is included.}

\item{height}{string; The height of the SAS output.}

\item{width}{string; The width of the SAS output.}
}
\value{
\code{htmlwidget}; HTML5 output.
}
\description{
Execute SAS code in current session and render html output.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
sas_connect()

sas_run_string("PROC MEANS DATA = sashelp.cars;RUN;")
\dontshow{\}) # examplesIf}
}
\seealso{
Other code execution functions: 
\code{\link{sas_run_file}()},
\code{\link{sas_run_selected}()}
}
\concept{code execution functions}
