% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.savvSh.R
\name{predict.savvySh_model}
\alias{predict.savvySh_model}
\title{Predict Method for Slab and Shrinkage Linear Regression Models}
\usage{
\method{predict}{savvySh_model}(
  object,
  newx = NULL,
  type = c("response", "coefficients"),
  estimator = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \code{savvySh_model} object produced by \code{savvySh}.}

\item{newx}{A numeric matrix of new predictor data for which to generate predictions.
This argument is required if \code{type = "response"} and is ignored if \code{type = "coefficients"}.}

\item{type}{A character string specifying the output type. Options are \code{"response"} to return
predicted values and \code{"coefficients"} to extract regression coefficient vectors. Defaults to \code{"response"}.}

\item{estimator}{A character vector naming one or more shrinkage estimator(s) to use.
These must match names present in \code{object$coefficients}. If \code{NULL},
all available estimators are used.}

\item{...}{Additional arguments (currently unused).}
}
\value{
If \code{type = "response"}, the function returns:
\itemize{
  \item A numeric vector of predicted values if exactly one estimator is specified;
  \item Otherwise, a named list of numeric vectors, one for each specified estimator.
}
If \code{type = "coefficients"}, the function returns:
\itemize{
  \item A named numeric vector of regression coefficients if exactly one estimator is specified;
  \item Otherwise, a named list of numeric vectors corresponding to each specified estimator.
}
}
\description{
Generate predictions (fitted values) or extract regression coefficients from a
\code{savvySh_model} object returned by \code{savvySh}. This function allows you to
specify one or more shrinkage estimators (via the \code{estimator} parameter) available
in the model. If no estimator is specified, all available estimators are used and their
results are returned in a named list.
}
\details{
The behavior depends on the value of \code{type}:
\describe{
  \item{\code{"response"}:}{Generates predicted values using the coefficient estimates
      from the specified shrinkage estimator(s) for new data supplied via \code{newx}.}
  \item{\code{"coefficients"}:}{Extracts the regression coefficient vector(s) corresponding
      to the specified estimator(s). Coefficient names are assigned based on whether an intercept
      is present (for Linear shrinkage, no intercept).}
}

If no \code{estimator} is specified, the function returns results for all available estimators
as a named list. If a single estimator is specified (or only one is provided in the vector), the result
is returned as a numeric vector (for coefficients) or a numeric vector of predictions (for response).
}
\examples{
# Generate simulated data
set.seed(123)
x <- matrix(rnorm(100 * 5), 100, 5)
y <- rnorm(100)

# Fit a Multiplicative shrinkage model
fit <- savvySh(x, y, model_class = "Multiplicative")

# Generate predictions for new data
new_x <- matrix(rnorm(10 * 5), 10, 5)
preds <- predict(fit, newx = new_x, type = "response")

# Extract coefficients for specific estimators
coefs_st <- predict(fit, type = "coefficients", estimator = "St")

}
\seealso{
\code{\link{savvySh}} for fitting slab and shrinkage linear models,
  \code{\link{coef.savvySh_model}} for direct coefficient extraction.
}
\author{
Ziwei Chen, Vali Asimit, Marina Anca Cidota, Jennifer Asimit\cr
Maintainer: Ziwei Chen <ziwei.chen.3@citystgeorges.ac.uk>
}
