% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.savvySh.R
\name{summary.savvySh_model}
\alias{summary.savvySh_model}
\title{Summarize a Slab and Shrinkage Linear Regression Model}
\usage{
\method{summary}{savvySh_model}(object, estimator = NULL, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{savvySh_model}, produced by \code{savvySh}.}

\item{estimator}{A character vector naming one or more estimators to summarize (e.g., \code{"St"}, \code{"DSh"},
\code{"SR"}, \code{"GSR"}, \code{"Sh"}, etc.). If \code{NULL} (default), summaries for all available estimators are printed.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns a \code{data.frame} summarizing key metrics for each estimator (including estimator name,
number of non-zero coefficients, and optimal \code{lambda} if available).
}
\description{
Provides a comprehensive summary for one or more shrinkage estimators contained within a
\code{savvySh_model} object produced by \code{savvySh}. The summary includes estimated coefficients,
confidence intervals, residual statistics, R-squared measures, F-statistics, and information criteria (AIC, BIC)
for each specified estimator.
}
\details{
For each estimator present in the \code{savvySh_model} object (or for the user-specified subset), this function computes:
\itemize{
  \item A summary of the residual distribution (quantiles).
  \item A coefficient table including estimates, standard errors, t-values, p-values, and confidence intervals.
  \item Residual standard error and degrees of freedom.
  \item R-squared and adjusted R-squared measures.
  \item F-statistic (and its p-value) for testing overall regression significance.
  \item Information criteria (AIC, BIC) and deviance for model fit.
}
These results are printed in sequence for the selected estimator(s). If no estimator is specified,
summaries for all available estimators are printed.
}
\examples{
# Generate simulated data for demonstration
set.seed(123)
x <- matrix(rnorm(100 * 5), 100, 5)
y <- rnorm(100)

# Fit a Slab Regression model
fit <- savvySh(x, y, model_class = "Slab")

# Print a detailed summary for all estimators (SR and GSR)
summary(fit)

# Summarize only a specific estimator
summary(fit, estimator = "GSR")

}
\seealso{
\code{\link{savvySh}} for fitting slab and shrinkage linear models,
  \code{\link{predict.savvySh_model}} for generating predictions,
  \code{\link{coef.savvySh_model}} for extracting coefficients directly.
}
\author{
Ziwei Chen, Vali Asimit, Marina Anca Cidota, Jennifer Asimit\cr
Maintainer: Ziwei Chen <ziwei.chen.3@citystgeorges.ac.uk>
}
