% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.performance_simres.R
\name{plot.see_performance_simres}
\alias{plot.see_performance_simres}
\title{Plot method for check model for (non-)normality of residuals}
\usage{
\method{plot}{see_performance_simres}(
  x,
  linewidth = 0.8,
  size_point = 2,
  size_title = 12,
  size_axis_title = base_size,
  base_size = 10,
  alpha = 0.2,
  alpha_dot = 0.8,
  theme = NULL,
  colors = c("#3aaf85", "#1b6ca8"),
  detrend = FALSE,
  transform = NULL,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{linewidth}{Numeric value specifying size of line geoms.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{base_size, size_axis_title, size_title}{Numeric value specifying size of
axis and plot titles.}

\item{alpha}{Numeric value specifying alpha level of the confidence bands.}

\item{alpha_dot}{Numeric value specifying alpha level of the point geoms.}

\item{theme}{A ggplot2-theme function, e.g. \code{theme = theme_lucid()} or
\code{theme = ggplot2::theme_dark()}.}

\item{colors}{Character vector of length two, indicating the colors (in
hex-format) for points and line.}

\item{detrend}{Logical that decides if Q-Q and P-P plots should be de-trended
(also known as \emph{worm plots}).}

\item{transform}{Function to transform the residuals. If \code{NULL} (default),
no transformation is applied and uniformly distributed residuals are expected.
See argument \code{quantileFuntion} in \code{?DHARMa:::residuals.DHARMa} for more details.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_residuals()} resp.
\code{performance::simulate_residuals()} function.
}
\examples{
\dontshow{if (require("glmmTMB") && require("qqplotr") && require("DHARMa")) withAutoprint(\{ # examplesIf}
data(Salamanders, package = "glmmTMB")
model <- glmmTMB::glmmTMB(
  count ~ mined + spp + (1 | site),
  family = poisson(),
  data = Salamanders
)
simulated_residuals <- performance::simulate_residuals(model)
plot(simulated_residuals)

# or
simulated_residuals <- performance::simulate_residuals(model)
result <- performance::check_residuals(simulated_residuals)
plot(result)
\dontshow{\}) # examplesIf}
}
\seealso{
See also the vignette about \href{https://easystats.github.io/performance/articles/check_model.html}{\code{check_model()}}.
}
