% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{inverse_haldane_mapping}
\alias{inverse_haldane_mapping}
\title{Inverse Haldane Mapping Function}
\usage{
inverse_haldane_mapping(recombination_fraction)
}
\arguments{
\item{recombination_fraction}{Recombination fraction (r) between 0 and 0.5.}
}
\value{
Genetic distance in Morgans.
}
\description{
Converts recombination fraction back to genetic distance (in Morgans).
This is the inverse of Haldane's mapping function.
}
\details{
\strong{Mathematical Formula:}

Solving Haldane's equation for d:
\deqn{d = -\frac{1}{2} \ln(1 - 2r)}
}
\examples{
# Convert recombination fraction to distance
inverse_haldane_mapping(0.25) # Returns ~0.347 Morgans
inverse_haldane_mapping(0.5) # Returns Inf (unlinked)
}
