% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrained_indices.R
\name{ppg_lpsi}
\alias{ppg_lpsi}
\title{Predetermined Proportional Gains (PPG-LPSI)}
\usage{
ppg_lpsi(pmat, gmat, k, wmat = NULL, wcol = 1, GAY)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits)}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits)}

\item{k}{Vector of desired proportional gains (length n_traits).
Example: k = c(2, 1, 1) means trait 1 should gain twice as much as traits 2 and 3.}

\item{wmat}{Optional weight matrix for GA/PRE calculation}

\item{wcol}{Weight column number (default: 1)}

\item{GAY}{Genetic advance of comparative trait (optional)}
}
\value{
List with:
  \itemize{
    \item \code{summary} - Data frame with coefficients and metrics
    \item \code{b} - Vector of PPG-LPSI coefficients
    \item \code{Delta_G} - Expected genetic gains per trait
    \item \code{phi} - Proportionality constant
  }
}
\description{
Implements the PPG-LPSI where breeders specify desired proportional gains
between traits rather than restricting specific traits to zero.
Based on Tallis (1962).
}
\details{
\strong{Mathematical Formulation (Chapter 3, Section 3.2):}

The PPG-LPSI achieves gains in specific proportions: Delta_G = phi*k

Coefficient formula (Tallis, 1962):
\deqn{b = P^{-1}G(G'P^{-1}G)^{-1}k}{b = P^(-1)G(G'P^(-1)G)^(-1)k}

Where:
- k = Vector of desired proportions
- phi = Proportionality constant (determined by selection intensity and variances)

The constraint ensures Delta_G1:Delta_G2:Delta_G3 = k1:k2:k3
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Gains in ratio 2:1:1:1:1:1:1
k <- c(2, 1, 1, 1, 1, 1, 1)
result <- ppg_lpsi(pmat, gmat, k)
}
}
