% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapackage_functions.R
\name{sitrep_install_deps}
\alias{sitrep_install_deps}
\title{Install all sitrep ecosystem dependencies for offline use}
\usage{
sitrep_install_deps(
  upgrade = "ask",
  dependencies = TRUE,
  repos = getOption("repos"),
  quiet = FALSE,
  force = FALSE
)
}
\arguments{
\item{upgrade}{Should packages be upgraded? Options: "ask", "always", "never". Default is "ask"}

\item{dependencies}{Should dependencies be installed? Default is TRUE}

\item{repos}{Repository to use. Default uses getOption("repos")}

\item{quiet}{Should installation be quiet? Default is FALSE}

\item{force}{Should installation proceed without prompts? Default is FALSE}
}
\value{
Character vector of all dependency package names (invisibly).
}
\description{
This function provides code to install all packages needed for the complete
sitrep ecosystem, ensuring you have everything needed for working without
internet connection.
}
\details{
This function reads the sitrep DESCRIPTION file and provides code to
install all packages listed in Depends, Imports, and Suggests fields.
This ensures complete functionality in offline environments.
}
\examples{
\donttest{
# Install everything for offline field work (with prompts)
sitrep_install_deps()

# Install without prompts
sitrep_install_deps(force = TRUE)

# Install quietly without prompts or upgrades
sitrep_install_deps(upgrade = "never", quiet = TRUE, force = TRUE)
}

}
