% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smash.R
\name{smash.poiss}
\alias{smash.poiss}
\title{Estimate the underlying intensity for Poisson counts.}
\usage{
smash.poiss(
  x,
  post.var = FALSE,
  log = FALSE,
  reflect = FALSE,
  glm.approx.param = list(),
  ashparam = list(),
  cxx = TRUE,
  lev = 0
)
}
\arguments{
\item{x}{A vector of Poisson counts (reflection is done
automatically if length of \code{x} is not a power of 2).}

\item{post.var}{Boolean, indicates if the posterior variance should
be returned.}

\item{log}{bool, determines if smoothed signal is returned on log
scale or not}

\item{reflect}{A logical indicating if the signals should be
reflected.}

\item{glm.approx.param}{A list of parameters to be passed to
\code{glm.approx}; default values are set by function
\code{setGlmApproxParam}.}

\item{ashparam}{A list of parameters to be passed to \code{ash};
default values are set by function \code{setAshParam.poiss}.}

\item{cxx}{bool, indicates if C++ code should be used to create TI
tables.}

\item{lev}{integer from 0 to J-1, indicating primary level of
resolution. Should NOT be used (ie shrinkage is performed at all
resolutions) unless there is good reason to do so.}
}
\value{
\code{smash.poiss} returns the mean estimate by default,
  with the posterior variance as an additional component if
  \code{post.var} is TRUE.
}
\description{
Main smoothing procedure for Poisson data. Takes a
  univariate inhomogeneous Poisson process and estimates its mean
  intensity.
}
\details{
We assume that the data come from the model \eqn{Y_t \sim
  Pois(\mu_t)} for \eqn{t=1,...,T}, where \eqn{\mu_t} is the
  underlying intensity, assumed to be spatially structured (or
  treated as points sampled from a smooth continous function). The
  \eqn{Y_t} are assumed to be independent. Smash provides estimates
  of \eqn{\mu_t} (and its posterior variance if desired).
}
\examples{

n=2^10
t=1:n/n
spike.f = function(x) (0.75*exp(-500*(x-0.23)^2) +
  1.5*exp(-2000*(x-0.33)^2) + 3*exp(-8000*(x-0.47)^2) +
  2.25*exp(-16000*(x-0.69)^2)+0.5*exp(-32000*(x-0.83)^2))
mu.s=spike.f(t)
mu.t=0.01+mu.s
X.s=rpois(n,mu.t)
mu.est=smash.poiss(X.s)
plot(mu.t,type='l')
lines(mu.est,col=2)

}
