% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_las_colors}
\alias{merge_las_colors}
\title{Merge RGB colors from two colorized LAS objects}
\usage{
merge_las_colors(las1, las2, alpha = 0.5, method = "alpha")
}
\arguments{
\item{las1}{First LAS object with R, G, B fields}

\item{las2}{Second LAS object with R, G, B fields (must have same number of points as las1)}

\item{alpha}{Numeric value between 0 and 1 controlling the blend ratio.
0 = all las1 colors, 1 = all las2 colors, 0.5 = equal blend. Default is 0.5.}

\item{method}{Character string specifying blend method: "alpha" for alpha blending,
"multiply" for multiplicative blending, "screen" for screen blending,
"overlay" for overlay blending. Default is "alpha".}
}
\value{
A LAS object (copy of las1) with merged R, G, and B fields
}
\description{
Blends the RGB values from two LAS objects to create a new composite coloring.
Useful for combining different coloring methods (e.g., ambient occlusion with raster RGB).
}
\details{
Blending methods:
\describe{
\item{alpha}{Simple linear interpolation: (1-alpha)\emph{las1 + alpha}las2}
\item{multiply}{Multiplicative blend (darkens): (las1 * las2) / 255}
\item{screen}{Screen blend (lightens): 255 - ((255-las1) * (255-las2)) / 255}
\item{overlay}{Overlay blend: combines multiply and screen based on base color}
}

Common use cases:
\itemize{
\item Combine ambient occlusion (PCV/SSAO) with aerial RGB for realistic shading
\item Blend attribute coloring with terrain colors
\item Overlay multiple visualization layers
}
}
\examples{
\donttest{
# Load example LAS file
LASfile <- system.file("extdata", "ALS_Clip.laz", package="spanner")
las <- readLAS(LASfile)

# Combine SSAO ambient occlusion with aerial RGB
las_ao <- colorize_las(las, method="ssao", palette=c("black", "white"))
rgb_file <- system.file("extdata", "UAS_Clip_RGB.tif", package="spanner")
las_rgb <- colorize_las(las, method="rgb", raster_path=rgb_file)
las_merged <- merge_las_colors(las_ao, las_rgb, alpha=0.3, method="multiply")

# Blend attribute coloring with RGB at 50/50
las_height <- colorize_las(las, method="attr", attribute_name="Z",
                           palette=c("blue", "red"))
las_merged <- merge_las_colors(las_height, las_rgb, alpha=0.5)
}

}
