
test_that("the example files are loaded correctly", {
  library(terra)

  # Path management based on the mode (development or installed package)
  if (dir.exists("inst/extdata")) {
    # Development mode: Files are in the 'inst/extdata' directory
    albedo_path <- normalizePath(file.path(getwd(), "inst", "extdata", "albedo_reduced.tif"))
    TS_TA_path <- normalizePath(file.path(getwd(), "inst", "extdata", "TS_TA_reduced.tif"))
  } else {
    # Package installed mode: Files are installed via the package
    albedo_path <- system.file("extdata", "albedo_reduced.tif", package = "ssebiEF")
    TS_TA_path <- system.file("extdata", "TS_TA_reduced.tif", package = "ssebiEF")
  }

  # Load the rasters
  albedo <- rast(albedo_path)
  TS_TA <- rast(TS_TA_path)

  # Check if the files exist
  expect_true(file.exists(albedo_path), info = "albedo_reduced.tif file not found")
  expect_true(file.exists(TS_TA_path), info = "TS_TA_reduced.tif file not found")

  # Check the object classes
  expect_s4_class(albedo, "SpatRaster")
  expect_s4_class(TS_TA, "SpatRaster")
})

