% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{split_len}
\alias{split_len}
\title{Split a list or some other \code{split()}-able object by lengths}
\usage{
split_len(x, l)
}
\arguments{
\item{x}{an object with a \code{\link[=split]{split()}} method.}

\item{l}{a vector of lengths of the subsets.}
}
\value{
A list with elements of the same type as \code{x}.
}
\description{
\code{split_len()} splits an object, such as a list or a data frame,
into subsets with specified lengths.
}
\examples{
x <- 1:10
l <- 1:4

o <- split_len(x, l)

stopifnot(identical(lengths(o), l))
stopifnot(identical(unlist(o), x))

}
