% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{pi.var}
\alias{pi.var}
\title{Prediction limits for a sample variance in a future study}
\usage{
pi.var(alpha, var, n0, n, type)
}
\arguments{
\item{alpha}{alpha value for upper 1-alpha confidence}

\item{var}{estimated variance from prior study}

\item{n0}{sample size used to estimate the variance}

\item{n}{planned sample size of future study}

\item{type}{\itemize{
\item set to 1 for two-sided prediction interval
\item set to 2 for one-sided upper prediction limit
\item set to 3 for one-sided lower prediction limit
}}
}
\value{
Returns two-sided or one-sided prediction limit(s) of an estimate variance
in a future study
}
\description{
Computes a two-sided or one-sided prediction limit for the estimated
variance in a future study for a planned sample size of n. The prediction
limit uses a variance estimate from a prior study of size n0.

Several confidence interval sample size functions in this package require
a planning value of the expected sample variance in the planned study.
A one-sided upper variance prediction limit is useful as a variance
planning value for a conservatively large sample size required to obtain
a confidence interval with desired width. This strategy for specifying a
variance planning value is useful in applications where the population
variance in the prior study is assumed to be very similar to the population
variance in the planned study.

For more details, see Section 1.31 of Bonett (2021, Volume 1)
}
\examples{
pi.var(.05, 15, 40, 100, 2)

# Should return:
#      UL
# 23.9724
 

}
\references{
\insertRef{Hahn1972}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
