% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_effects.R
\name{RandomEffectSamples}
\alias{RandomEffectSamples}
\title{Random Effect Container C++ Wrapper}
\description{
Class that wraps the "persistent" aspects of a C++ random effects model, including
draws of the parameters and a map from the original label indices to the
0-indexed label numbers used to place group samples in memory (i.e. the
first label is stored in column 0 of the sample matrix, the second label
is store in column 1 of the sample matrix, etc...)

This class is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai

Coordinates various C++ random effects classes and persists those
needed for prediction / serialization
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rfx_container_ptr}}{External pointer to a C++ StochTree::RandomEffectsContainer class}

\item{\code{label_mapper_ptr}}{External pointer to a C++ StochTree::LabelMapper class}

\item{\code{training_group_ids}}{Unique vector of group IDs that were in the training dataset}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RandomEffectSamples-new}{\code{RandomEffectSamples$new()}}
\item \href{#method-RandomEffectSamples-load_in_session}{\code{RandomEffectSamples$load_in_session()}}
\item \href{#method-RandomEffectSamples-load_from_json}{\code{RandomEffectSamples$load_from_json()}}
\item \href{#method-RandomEffectSamples-append_from_json}{\code{RandomEffectSamples$append_from_json()}}
\item \href{#method-RandomEffectSamples-load_from_json_string}{\code{RandomEffectSamples$load_from_json_string()}}
\item \href{#method-RandomEffectSamples-append_from_json_string}{\code{RandomEffectSamples$append_from_json_string()}}
\item \href{#method-RandomEffectSamples-predict}{\code{RandomEffectSamples$predict()}}
\item \href{#method-RandomEffectSamples-extract_parameter_samples}{\code{RandomEffectSamples$extract_parameter_samples()}}
\item \href{#method-RandomEffectSamples-delete_sample}{\code{RandomEffectSamples$delete_sample()}}
\item \href{#method-RandomEffectSamples-extract_label_mapping}{\code{RandomEffectSamples$extract_label_mapping()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-new"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-new}{}}}
\subsection{Method \code{new()}}{
Create a new RandomEffectSamples object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{RandomEffectSamples} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-load_in_session"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-load_in_session}{}}}
\subsection{Method \code{load_in_session()}}{
Construct RandomEffectSamples object from other "in-session" R objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$load_in_session(
  num_components,
  num_groups,
  random_effects_tracker
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_components}}{Number of "components" or bases defining the random effects regression}

\item{\code{num_groups}}{Number of random effects groups}

\item{\code{random_effects_tracker}}{Object of type \code{RandomEffectsTracker}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-load_from_json"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-load_from_json}{}}}
\subsection{Method \code{load_from_json()}}{
Construct RandomEffectSamples object from a json object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$load_from_json(
  json_object,
  json_rfx_container_label,
  json_rfx_mapper_label,
  json_rfx_groupids_label
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_object}}{Object of class \code{CppJson}}

\item{\code{json_rfx_container_label}}{Label referring to a particular rfx sample container (i.e. "random_effect_container_0") in the overall json hierarchy}

\item{\code{json_rfx_mapper_label}}{Label referring to a particular rfx label mapper (i.e. "random_effect_label_mapper_0") in the overall json hierarchy}

\item{\code{json_rfx_groupids_label}}{Label referring to a particular set of rfx group IDs (i.e. "random_effect_groupids_0") in the overall json hierarchy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RandomEffectSamples} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-append_from_json"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-append_from_json}{}}}
\subsection{Method \code{append_from_json()}}{
Append random effect draws to \code{RandomEffectSamples} object from a json object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$append_from_json(
  json_object,
  json_rfx_container_label,
  json_rfx_mapper_label,
  json_rfx_groupids_label
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_object}}{Object of class \code{CppJson}}

\item{\code{json_rfx_container_label}}{Label referring to a particular rfx sample container (i.e. "random_effect_container_0") in the overall json hierarchy}

\item{\code{json_rfx_mapper_label}}{Label referring to a particular rfx label mapper (i.e. "random_effect_label_mapper_0") in the overall json hierarchy}

\item{\code{json_rfx_groupids_label}}{Label referring to a particular set of rfx group IDs (i.e. "random_effect_groupids_0") in the overall json hierarchy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-load_from_json_string"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-load_from_json_string}{}}}
\subsection{Method \code{load_from_json_string()}}{
Construct RandomEffectSamples object from a json object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$load_from_json_string(
  json_string,
  json_rfx_container_label,
  json_rfx_mapper_label,
  json_rfx_groupids_label
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_string}}{JSON string which parses into object of class \code{CppJson}}

\item{\code{json_rfx_container_label}}{Label referring to a particular rfx sample container (i.e. "random_effect_container_0") in the overall json hierarchy}

\item{\code{json_rfx_mapper_label}}{Label referring to a particular rfx label mapper (i.e. "random_effect_label_mapper_0") in the overall json hierarchy}

\item{\code{json_rfx_groupids_label}}{Label referring to a particular set of rfx group IDs (i.e. "random_effect_groupids_0") in the overall json hierarchy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RandomEffectSamples} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-append_from_json_string"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-append_from_json_string}{}}}
\subsection{Method \code{append_from_json_string()}}{
Append random effect draws to \code{RandomEffectSamples} object from a json object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$append_from_json_string(
  json_string,
  json_rfx_container_label,
  json_rfx_mapper_label,
  json_rfx_groupids_label
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_string}}{JSON string which parses into object of class \code{CppJson}}

\item{\code{json_rfx_container_label}}{Label referring to a particular rfx sample container (i.e. "random_effect_container_0") in the overall json hierarchy}

\item{\code{json_rfx_mapper_label}}{Label referring to a particular rfx label mapper (i.e. "random_effect_label_mapper_0") in the overall json hierarchy}

\item{\code{json_rfx_groupids_label}}{Label referring to a particular set of rfx group IDs (i.e. "random_effect_groupids_0") in the overall json hierarchy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-predict"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-predict}{}}}
\subsection{Method \code{predict()}}{
Predict random effects for each observation implied by \code{rfx_group_ids} and \code{rfx_basis}.
If a random effects model is "intercept-only" the \code{rfx_basis} will be a vector of ones of size \code{length(rfx_group_ids)}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$predict(rfx_group_ids, rfx_basis = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rfx_group_ids}}{Indices of random effects groups in a prediction set}

\item{\code{rfx_basis}}{(Optional) Basis used for random effects prediction}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix with as many rows as observations provided and as many columns as samples drawn of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-extract_parameter_samples"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-extract_parameter_samples}{}}}
\subsection{Method \code{extract_parameter_samples()}}{
Extract the random effects parameters sampled. With the "redundant parameterization"
of Gelman et al (2008), this includes four parameters: alpha (the "working parameter"
shared across every group), xi (the "group parameter" sampled separately for each group),
beta (the product of alpha and xi, which corresponds to the overall group-level random effects),
and sigma (group-independent prior variance for each component of xi).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$extract_parameter_samples()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of arrays. The alpha array has dimension (\code{num_components}, \code{num_samples}) and is simply a vector if \code{num_components = 1}.
The xi and beta arrays have dimension (\code{num_components}, \code{num_groups}, \code{num_samples}) and are simply matrices if \code{num_components = 1}.
The sigma array has dimension (\code{num_components}, \code{num_samples}) and is simply a vector if \code{num_components = 1}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-delete_sample"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-delete_sample}{}}}
\subsection{Method \code{delete_sample()}}{
Modify the \code{RandomEffectsSamples} object by removing the parameter samples index by \code{sample_num}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$delete_sample(sample_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sample_num}}{Index of the RFX sample to be removed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectSamples-extract_label_mapping"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectSamples-extract_label_mapping}{}}}
\subsection{Method \code{extract_label_mapping()}}{
Convert the mapping of group IDs to random effect components indices from C++ to R native format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectSamples$extract_label_mapping()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List mapping group ID to random effect components.
}
}
}
