
init_substr_info <- function(token) {
  N <- length(token)
  n_rows <- N * (N + 1) / 2

  starts   <- integer(n_rows)
  lengths  <- integer(n_rows)
  exprs    <- character(n_rows)

  row <- 0L
  for (k in seq(N, 1)) {
    for (s in seq_len(N - k + 1)) {
      row <- row + 1L
      starts[row]  <- s
      lengths[row] <- k
      exprs[row]   <- paste0(token[s:(s + k - 1)], collapse = "")
    }
  }

  data.frame(
    start       = starts,
    n_tokens    = lengths,
    expr        = exprs,
    type        = "",
    translation = "",
    stringsAsFactors = FALSE
  )
}
