% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{get_stem_tilt}
\alias{get_stem_tilt}
\title{Get tree tilt from QSM}
\usage{
get_stem_tilt(qsm, terminus_diam_cm = 4)
}
\arguments{
\item{qsm}{a QSM loaded using `[load_qsm()]`.}

\item{terminus_diam_cm}{numeric - trunk diameter at which it is treated as a branch.}
}
\value{
A single numeric value giving stem tilt in degrees from vertical.
}
\description{
This function calculates tilt of a tree from a QSM. The function identifies
the upper and lower extreme segments of the QMS (trunk sections only) and
computes a vector between them, and returns the devation of that angle
from directly vertical.
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
get_stem_tilt(qsm)
}
