% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_discounting.R
\name{apply_discounting}
\alias{apply_discounting}
\title{Calculate the discounted (net present value) of costs or effects}
\usage{
apply_discounting(
  values,
  discount_rate = c("costs", "effects"),
  times,
  aggregate = FALSE,
  digits = NULL
)
}
\arguments{
\item{values}{A numeric (vector of) costs or effects over time (one value per period).}

\item{discount_rate}{Specifies the discount rate to be used. Acceptable values are:
"costs" (0.03), "effects" (0.015), or a custom numeric value such as 0.04.}

\item{times}{A numeric (vector of) time points indicating the time used for the discounting. The length must match the length of the values vector. Since the default discounting is annual, the time points should be in years. The length of this vector should be the same as the length of the \code{values} vector. When the first year is not discounted, the time points should start at 0 (e.g., c(0, 1, 2) for three years with NO discounting in the first year). When the first year is discounted, the time points should start at 1 (e.g., c(1, 2, 3) for three years WITH discounting in the first year). In case costs or effects are accrued in time steps other they annual, the time points should be adjusted accordingly, see more details in the vignettes of this package about discounting.}

\item{aggregate}{A logical: indicating whether to sum the discounted values. Default is FALSE.}

\item{digits}{A numeric value to indicate the number of digits to round the value. Default is 3 digits}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
The apply_discounting function is designed to calculate the net present value of future costs or effects using a constant  discount rate, following the Dutch guidelines for economic evaluations in health care.  (section 2.6.1.2 version 2024). Here's a breakdown of how the function works:
}
\details{
This function ensures consistent application of discount rates in cost-effectiveness
analyses, in line with Dutch guidelines. Custom rates can be specified when needed.
}
\examples{
# NO Discounting in First Year (t starts at 0)
# constant cost of 100 for 3 years
apply_discounting(values = rep(100, 3), discount_rate = "costs", times = c(0, 1, 2))

# WITH discounting in first year (t starts at 1)
# Constant cost of 100 for 3 years,
apply_discounting(values = rep(100, 3),
                   discount_rate = "costs",
                   times = c(1, 2, 3))

# Present value of 100 euro in 3 years
apply_discounting(values = 100, discount_rate = "costs", times = 3)

# Custom Discount Rate
# discount rate of 4\%, no discounting in first year
apply_discounting(values = rep(100, 3),
                  discount_rate = 0.04,
                  times = c(0, 1, 2))
# This will give you a messages to inform you about the different discount rate

# Same applies to utility values
# Utility values with aggregation - NO discounting in first year
apply_discounting(values = c(0.98, 0.82, 0.79),
                  discount_rate = "effect",
                  times = c(0, 1, 2),
                  aggregate = TRUE, digits = 3)

}
