% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_pp_patient_timeline.R
\name{tm_g_pp_patient_timeline}
\alias{tm_g_pp_patient_timeline}
\title{teal Module: Patient Profile Timeline Plot}
\usage{
tm_g_pp_patient_timeline(
  label,
  dataname_adcm = "ADCM",
  dataname_adae = "ADAE",
  parentname = "ADSL",
  patient_col = "USUBJID",
  aeterm = NULL,
  cmdecod = NULL,
  aetime_start = NULL,
  aetime_end = NULL,
  dstime_start = NULL,
  dstime_end = NULL,
  aerelday_start = NULL,
  aerelday_end = NULL,
  dsrelday_start = NULL,
  dsrelday_end = NULL,
  font_size = c(12L, 12L, 25L),
  plot_height = c(700L, 200L, 2000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname_adcm}{(\code{character})\cr name of \code{ADCM} dataset or equivalent.}

\item{dataname_adae}{(\code{character})\cr name of \code{ADAE} dataset or equivalent.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{patient_col}{(\code{character})\cr name of patient ID variable.}

\item{aeterm}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AETERM} variable from \code{dataname}.}

\item{cmdecod}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDECOD} variable from \code{dataname_adcm}.}

\item{aetime_start}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for the \code{ASTDTM} variable from \code{dataname_adae}.}

\item{aetime_end}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AENDTM} variable from \code{dataname_adae}.}

\item{dstime_start}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for the \code{CMASTDTM} variable from \code{dataname_adcm}.}

\item{dstime_end}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMAENDTM} variable from \code{dataname_adcm}.}

\item{aerelday_start}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for the \code{ASTDY} variable from \code{dataname_adae}.}

\item{aerelday_end}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for the \code{AENDY} variable from \code{dataname_adae}.}

\item{dsrelday_start}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for the \code{ASTDY} variable from \code{dataname_adcm}.}

\item{dsrelday_end}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for the \code{AENDY} variable from \code{dataname_adcm}.}

\item{font_size}{(\code{numeric})\cr numeric vector of length 3 of current, minimum and maximum font size values.}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a patient profile timeline \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type plot using ADaM datasets.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{plot} (\code{ggplot})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_g_pp_patient_timeline(
   ..., # arguments for module
   decorators = list(
     plot = teal_transform_module(...) # applied only to `plot` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\section{Reporting}{



This module returns an object of class \code{teal_module}, that contains a \code{server} function.
Since the server function returns a \code{teal_report} object, this makes this module reportable, which means that
the reporting functionality will be turned on automatically by the \code{teal} framework.

For more information on reporting in \code{teal}, see the vignettes:
\itemize{
\item \code{vignette("reportable-shiny-application", package = "teal.reporter")}
\item \code{vignette("adding-support-for-reporting-to-custom-modules", package = "teal")}
}

}

\examples{
library(nestcolor)

data <- teal_data()
data <- within(data, {
  library(teal.modules.clinical)
  library(formatters)
  library(dplyr)
  ADAE <- tmc_ex_adae
  ADSL <- filter(tmc_ex_adsl, USUBJID \%in\% ADAE$USUBJID)
  ADCM <- tmc_ex_adcm \%>\%
    mutate(
      CMSTDY = case_when(
        CMCAT == "medcl B" ~ 20,
        CMCAT == "medcl C" ~ 150,
        TRUE ~ 1
      ) \%>\% with_label("Study Day of Start of Medication"),
      CMENDY = case_when(
        CMCAT == "medcl B" ~ 700,
        CMCAT == "medcl C" ~ 1000,
        TRUE ~ 500
      ) \%>\% with_label("Study Day of End of Medication"),
      CMASTDTM = ASTDTM,
      CMAENDTM = AENDTM
    )
})

join_keys(data) <- default_cdisc_join_keys[c("ADSL", "ADAE", "ADCM")]
adcm_keys <- c("STUDYID", "USUBJID", "ASTDTM", "CMSEQ", "ATC1", "ATC2", "ATC3", "ATC4")
join_keys(data)["ADCM", "ADCM"] <- adcm_keys
join_keys(data)["ADAE", "ADCM"] <- c("STUDYID", "USUBJID")

app <- init(
  data = data,
  modules = modules(
    tm_g_pp_patient_timeline(
      label = "Patient Timeline",
      dataname_adae = "ADAE",
      dataname_adcm = "ADCM",
      parentname = "ADSL",
      patient_col = "USUBJID",
      plot_height = c(600L, 200L, 2000L),
      cmdecod = choices_selected(
        choices = variable_choices(data[["ADCM"]], "CMDECOD"),
        selected = "CMDECOD",
      ),
      aeterm = choices_selected(
        choices = variable_choices(data[["ADAE"]], "AETERM"),
        selected = c("AETERM")
      ),
      aetime_start = choices_selected(
        choices = variable_choices(data[["ADAE"]], "ASTDTM"),
        selected = c("ASTDTM")
      ),
      aetime_end = choices_selected(
        choices = variable_choices(data[["ADAE"]], "AENDTM"),
        selected = c("AENDTM")
      ),
      dstime_start = choices_selected(
        choices = variable_choices(data[["ADCM"]], "CMASTDTM"),
        selected = c("CMASTDTM")
      ),
      dstime_end = choices_selected(
        choices = variable_choices(data[["ADCM"]], "CMAENDTM"),
        selected = c("CMAENDTM")
      ),
      aerelday_start = choices_selected(
        choices = variable_choices(data[["ADAE"]], "ASTDY"),
        selected = c("ASTDY")
      ),
      aerelday_end = choices_selected(
        choices = variable_choices(data[["ADAE"]], "AENDY"),
        selected = c("AENDY")
      ),
      dsrelday_start = choices_selected(
        choices = variable_choices(data[["ADCM"]], "ASTDY"),
        selected = c("ASTDY")
      ),
      dsrelday_end = choices_selected(
        choices = variable_choices(data[["ADCM"]], "AENDY"),
        selected = c("AENDY")
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQSvxQpFD6RlzUAPqh4dYhYRGGOgDutKQAFrQQ7PFQuDogSjo67sxsnHDcvALCYhJSMvKl5QyVHMYBMGHkjKJBZRWe+ajUrIFtAIIAItNOkTqkMAQxcAAeMVChcDOzAMoAMkvGtNT9nKvrWzui1EUOBw4AQgBSAJKzOgCkuT86OYLAAkT1en1mQ0BswAwgBZJYrNabbb8AgwX4APh+bTKMEE4XI7FxZR08IOtlmAE0dABeHSyURwGJpLIUYkQUlcslwmHTWx0+kKMDwNHUHQvYU6AB+OgATAAGXAkrnwvkC2lCkVwMVkqWygCMAFYlSrSfZnDKdAazTYftj0pksjFqFB6HBqMSwAdSIJ+KwdLMoAGiMYdD6WKQdKGdHCdS0NCRhXJlZzufCnAA5al0hlQJkstl5M1lNX8wU6YWiyQS-U6ADsCtNae5PPVFarOprMLrBqbzdbZQti1lJoVtqxAIy2Rdbo9Xp9foDQZDYacEH40bDcf4CcswTAKbN8OmFNmtgR9NPlIvqdbJ6z58vgMfF5JQQAvkElAArIi5GIAGs4FYUR8mSGxUn4OBjCgYRSBiAhd1ENY-wA4DQOAAgvTmY5hSKYUgRcPBKzAOZ4WTABdJQdnRICQNEJZsOFCkHGpL58NIsF3g4kjCLPN8+LAcknAARU4wjbBhG0hP5GE5QksipIAZkUuSABZk1-f8IHo0DwPCORgEI2E4TU0zhUopZaJgPTRG09CGIMqAjJMhZzIosArNSZjvVsNiqV4giwG4iEtOCaB0CWXJMg5MoClzAo7x0PghBERj6VShowJJFYYgAcxidAirCWgKAQjR4CkOA4u5V13XFLUAAVSvKuxaCq3I9jwM0CmgeBUSgXQtSI-DeuSfrmRs3MTM85KuVQFhysmmayMOI4xpbUlFo0crEKIRquOeHjZk21txiIBC2VofKsijelsIANibI4ikVBVXvlfsjiPLaynRaDiE3B6sn-AgxBiJkRHUHVatbAhQZkMRc00FhaDdEREMR8GwIKYBjLWzzKMo4L4VmJwYQAeVOw95u5KG4Bh4HSLJinqbO7lftbIb+gxEGwYhhmmbh7kEYFjKdFRxh0foTGxaR3HknxtziOJ4KFlsJwsDM2mSx0IXyGZ3yNa1nWoS5LnuR5jrmVEcJGHuhlscFj1GcNkWuXlnGUbRjHmS9sRnOVtb3K8knSOvJ9kzprkDZ1XNjYEs3bRjnRrYGigjed0RIdd4W9YDiWpZluXs6DgnRrD9XXzN1Oyjjo2cJr8LW0trl+Dtm3Iftx3C9z6H3YL7Ofelv2sfF8vZp1tWWbhSPBLb+m88NhOvRPJOW851OO8q5lM4T7P+7d2Gh-FkeS-9su8Yriyq9nhZswXuv9eX+OHrXufm8PFOzSGxgPVCKwbukYD7iyPvnP6pJC7nzHoXSeIdVbh34pSKk0c9YN1Xsg6km8Lapz-gA4M6wNygIVuAwekD-rD3pMXWBV8lY31DjPQij5UG6woS-Aeb8GRN2zKw82pJF7xVEP-aggDgEOxITjMhJ92HQOob7WWl8J7XynpZJBZEzx8Ofhg9+WC+E-0gR3ERYj9781IQ3D2UCqGSwUaXZR9DVF32YbwtB7CdHcOcdg7+kD+FQiCEEWgYZ2C5H6FACw2hrA2BKGmUQOQICsGmOgdgaBUDAkELQIoKTgRMkYNoKYEAPxKDAB+SiQA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQSvxQpFD6RlzUAPqh4dYhYRGGOgDutKQAFrQQ7PFQuDogSjo67sxsnHDcvALCYhJSMvKl5QyVHMYBMGHkjKJBZRWe+ajUrIFtAIIAItNOkTqkMAQxcAAeMVChcDOzAMoAMkvGtNT9nKvrWzui1EUOBw4AQgBSAJKzOgCkuT86OYLAAkT1en1mQ0BswAwgBZJYrNabbb8AgwX4APh+bTKMEE4XI7FxZR08IOtlmAE0dABeHSyURwGJpLIUYkQUlcslwmHTWx0+kKMDwNHUHQvYU6AB+OgATAAGXAkrnwvkC2lCkVwMVkqWygCMAFYlSrSfZnDKdAazTYftj0pksjFqFB6HBqMSwAdSIJ+KwdLMoAGiMYdD6WKQdKGdHCdS0NCRhXJlZzufCnAA5al0hlQJkstl5M1lNX8wU6YWiyQS-U6ADsCtNae5PPVFarOprMLrBqbzdbZQti1lJoVtqxAIy2Rdbo9Xp9foDQZDYacEH40bDcf4CcswTAKbN8OmFNmtgR9NPlIvqdbJ6z58vgMfF5JQQAvkElAArIi5GIAGs4FYUR8mSGxUn4OBjCgYRSBiAhd1ENY-wA4DQOAAgvTmY5hSKYUgRcPBKzAOZ4WTABdJQdnRICQNEJZsOFCkHGpL58NIsF3g4kjCLPN8+LAcknAARU4wjbBhG0hP5GE5QksipIAZkUuSABZk1-f8IHo0DwPCORgEI2E4TU0zhUopZaJgPTRG09CGIMqAjJMhZzIosArNSZjvVsNiqV4giwG4iEtOCaB0CWXJMg5MoClzAo7x0PghBERj6VShowJJFYYgAcxidAirCWgKAQjR4CkOA4u5V13XFLUAAVSvKuxaCq3I9jwM0CmgeBUSgXQtSI-DeuSfrmRs3MTM85KuVQFhysmmayMOI4xpbUlFo0crEKIRquOeHjZk21txiIBC2VofKsijelsIANibI4ikVBVXvlfsjiPLaynRaDiE3B6sn-AgxBiJkRHUHVatbAhQZkMRc00FhaDdEREMR8GwIKYBjLWzzKMo4L4VmJwYQAeVOw95u5KG4Bh4HSLJinqbO7lftbIb+gxEGwYhhmmbh7kEYFjKdFRxh0foTGxaR3HknxtziOJ4KFlsJwsDM2mSx0IXyGZ3yNa1nWoS5LnuR5jrmVEcJGHuhlscFj1GcNkWuXlnGUbRjHmS9sRnOVtb3K8knSOvJ9kzprkDZ1XNjYEs3bRjnRrYGigjed0RIdd4W9YDiWpZluXs6DgnRrD9XXzN1Oyjjo2cJr8LW0trl+Dtm3Iftx3C9z6H3YL7Ofelv2sfF8vZp1tWWbhSPBLb+m88NhOvRPJOW851OO8q5lM4T7P+7d2Gh-FkeS-9su8Yriyq9nhZswXuv9eX+OHrXufm8PFOzSGxgPVCKwbukYD7iyPvnP6pJC7nzHoXSeIdVbh34pSKk0c9YN1Xsg6km8Lapz-gA4M6wNygIVuAwekD-rD3pMXWBV8lY31DjPQij5UG6woS-Aeb8GRN2zKw82pJF7xVEP-aggDgEOxITjMhJ92HQOob7WWl8J7XynpZJBZEzx8Ofhg9+WC+E-0gR3ERYj9781IQ3D2UCqGSwUaXZR9DVF32YbwtB7CdHcOcdg7+kD+FQiCEEWgYZ2C5H6FACw2hrA2BKGmUQOQICsGmOgdgaBUDAkELQIoKTgRMkYNoKYEAPxKDAB+SiQA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

