% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_tests_stf.R
\name{get_expect}
\alias{get_expect}
\title{Extract Expectation Calls from Parsed Testthat Code}
\usage{
get_expect(parsed_data, token_text = "^expect_")
}
\arguments{
\item{parsed_data}{data.frame. Parse data produced by
\code{utils::getParseData(parse(file, keep.source = TRUE), includeText = TRUE)}.
Must include the columns \code{token}, \code{text}, \code{line1},
and \code{line2}.}

\item{token_text}{Character. A regular expression used to detect
expectation‑style function calls. Defaults to \code{"^expect_"}.}
}
\value{
A \code{data.frame} where each row corresponds to a detected expectation.
The data frame contains:
\describe{
  \item{expectation}{Character. Name of the expectation function (e.g.,
        \code{"expect_equal"}).}
  \item{line1}{Integer. Starting line number of the expression.}
  \item{line2}{Integer. Ending line number of the expression.}
}
Returns \code{NULL} if no matching expectations are found.
}
\description{
This internal helper identifies expectation calls (e.g.,
`expect_equal()`, `expect_true()`, etc.) within parse data extracted from a
testthat test file. The function locates expectation function calls by
matching their token text and returns a structured data frame containing
the expectation names and their corresponding source line ranges.
}
\details{
The function:
\itemize{
  \item locates all rows where the token is \code{"SYMBOL_FUNCTION_CALL"}
        and the text matches \code{token_text},
  \item identifies the expression node corresponding to each expectation,
  \item extracts line ranges (\code{line1}, \code{line2}) describing where the
        expectation appears in the source file, and
  \item returns a consolidated data frame of results.
}

If no expectation calls are found, the function returns \code{NULL}.
This helper is used internally by STF mapping functions (such as
\code{map_test()} and \code{map_tests_stf()}) when constructing a full
hierarchy of test blocks and expectations.
}
\keyword{internal}
