% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_covr_skip_nstf.R
\name{run_covr_skip_nstf}
\alias{run_covr_skip_nstf}
\title{Run Coverage Analysis on Package Source and Non‑Standard Tests (NSTF)}
\usage{
run_covr_skip_nstf(pkg_source_path, test_pkg_data, cov_env)
}
\arguments{
\item{pkg_source_path}{Character. Path to the root of the package source
directory.}

\item{test_pkg_data}{List. Output from \code{check_pkg_tests_and_snaps()}
indicating the detected testing infrastructure (e.g., base tests,
Bioconductor tests) and the presence of snapshots or related artifacts.}

\item{cov_env}{Environment that holds the temporary coverage workspace and
shared state for the run.}
}
\value{
A named list containing coverage results and diagnostics:
\describe{
  \item{total_cov}{Numeric. Overall percentage of lines covered across the package.}
  \item{res_cov}{List. File‑ or element‑level coverage results (as derived from
        covr output), including per‑file coverage, any errors, and diagnostic notes.}
  \item{long_summary}{Long‑format summary of test outcomes (e.g., PASS/FAIL/ERROR/SKIPPED),
        when available from the NSTF execution.}
  \item{test_skip}{A data frame describing lines or regions skipped during coverage
        (if any). \code{NULL} if no skipping was required.}
  \item{untested_sources}{Character vector of source files for which no tests were found.}
}
If no valid NSTF test directory is detected, an “empty” coverage object may be
returned via \code{create_empty_covr_list()}.
}
\description{
This function maps package source files to non‑standard test scripts, detects
failing or skipped tests, executes the remaining tests manually, computes code
coverage, and returns structured results. It is intended for packages that do
not use the standard `testthat` framework (e.g., base R tests under `tests/`,
Bioconductor‑style tests in `inst/tests/`, or other legacy/custom scripts).
}
\details{
This NSTF workflow does not rely on `testthat` reporters. Instead, it:
\itemize{
  \item maps source files to available NSTF test scripts,
  \item identifies failing or problematic tests and derives a skip map,
  \item runs the remaining test scripts, and
  \item computes coverage on the successfully executed regions.
}
The output mirrors the structure returned by the STF skip‑aware workflow so
that downstream reporting remains consistent across frameworks.
}
\seealso{
Other nstf_utility: 
\code{\link{check_covr_skip_nstf}()},
\code{\link{check_covr_skip_testit}()},
\code{\link{get_nstf_test_path}()},
\code{\link{get_source_test_mapping_nstf}()}
}
\concept{nstf_utility}
\keyword{internal}
