% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tests_skip_stf.R
\name{safe_left_join}
\alias{safe_left_join}
\title{Safely perform a left join with error handling}
\usage{
safe_left_join(x, y, by, relationship = "many-to-many", ...)
}
\arguments{
\item{x}{A data frame or tibble. The left-hand side of the join.}

\item{y}{A data frame or tibble. The right-hand side of the join.}

\item{by}{A character vector specifying the join keys. Passed to
`dplyr::left_join()`.}

\item{relationship}{A string specifying the expected relationship between keys:
`"one-to-one"`, `"one-to-many"`, `"many-to-one"`, or `"many-to-many"`.
Defaults to `NULL` (no check).}
}
\value{
A data frame resulting from the left join if successful,
  otherwise `NULL` when an error occurs.
}
\description{
This helper function attempts to join two data frames using
`dplyr::left_join()`. If an error occurs during the join (for example,
due to missing columns or incompatible types), the function issues a
warning and returns `NULL` instead of stopping execution.
}
\keyword{internal}
