% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock-oo.R
\name{local_mocked_s3_method}
\alias{local_mocked_s3_method}
\alias{local_mocked_s4_method}
\title{Mock S3 and S4 methods}
\usage{
local_mocked_s3_method(generic, signature, definition, frame = caller_env())

local_mocked_s4_method(generic, signature, definition, frame = caller_env())
}
\arguments{
\item{generic}{A string giving the name of the generic.}

\item{signature}{A character vector giving the signature of the method.}

\item{definition}{A function providing the method definition, or \code{NULL} to
temporarily remove the method.}

\item{frame}{Calling frame which determines the scope of the mock.
Only needed when wrapping in another local helper.}
}
\description{
These functions temporarily override S3 or S4 methods. They can mock
methods that don't already exist, or temporarily remove a method by setting
\code{definition = NULL}.

Learn more about mocking in \code{vignette("mocking")}.
}
\examples{
x <- as.POSIXlt(Sys.time())
local({
  local_mocked_s3_method("length", "POSIXlt", function(x) 42)
  length(x)
})

length(x)
}
