% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_break.R
\name{llm_break}
\alias{llm_break}
\title{Create an \code{llm_break} object}
\usage{
llm_break(object_to_return = NULL, success = FALSE)
}
\arguments{
\item{object_to_return}{The object to return as the response result
from \code{\link[=send_prompt]{send_prompt()}} when this object is returned from an extraction or
validation function}

\item{success}{A logical indicating whether the \code{\link[=send_prompt]{send_prompt()}} loop break
should nonetheless be considered as a successful completion of the
extraction and validation process.
If \code{FALSE}, the \code{object_to_return} must
be \code{NULL} (as the response result of \code{\link[=send_prompt]{send_prompt()}} will always be 'NULL'
when the evaluation was unsuccessful); if \code{FALSE}, \code{\link[=send_prompt]{send_prompt()}} will also
print a warning about the unsuccessful evaluation.
If \code{TRUE}, the \code{object_to_return}
will be returned as the response result of \code{\link[=send_prompt]{send_prompt()}} (and \code{\link[=send_prompt]{send_prompt()}})
will print no warning about unsuccessful evaluation)}
}
\value{
An list of class "llm_break" containing the object to return and
a logical indicating whether the evaluation was successful
}
\description{
This object is used to break a extraction and validation loop defined in a \code{\link[=prompt_wrap]{prompt_wrap()}}
as evaluated by \code{\link[=send_prompt]{send_prompt()}}. When an extraction or validation function returns
this object, the loop will be broken and no further extraction or validation
functions are applied; instead, \code{\link[=send_prompt]{send_prompt()}} will be able to return
the result at that point. This may be useful in scenarios where
it is determined the LLM is unable to provide a response to a prompt.
}
\examples{
# Example usage within an extraction function similar to the one in 'quit_if()':
extraction_fn <- function(x) {
  quit_detect_regex <- "NO ANSWER"

  if (grepl(quit_detect_regex, x)) {
      return(llm_break(
        object_to_return = NULL,
        success = TRUE
      ))
  }

  return(x)
}

\dontrun{
  result <- "How many months old is the cat of my uncle?" |>
    answer_as_integer() |>
    prompt_wrap(
      modify_fn = function(prompt) {
        paste0(
          prompt, "\n\n",
          "Type only 'NO ANSWER' if you do not know."
        )
      },
      extraction_fn = extraction_fn,
      type = "break"
    ) |>
    send_prompt()
  result
  # NULL
}
}
\seealso{
\code{\link[=llm_feedback]{llm_feedback()}}

Other prompt_wrap: 
\code{\link{llm_feedback}()},
\code{\link{prompt_wrap}()}

Other prompt_evaluation: 
\code{\link{llm_feedback}()},
\code{\link{send_prompt}()}
}
\concept{prompt_evaluation}
\concept{prompt_wrap}
