% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_df.R
\name{write_toon_df}
\alias{write_toon_df}
\title{Write data.frame to tabular TOON}
\usage{
write_toon_df(
  df,
  file,
  tabular = TRUE,
  pretty = TRUE,
  indent = 2L,
  strict = TRUE
)
}
\arguments{
\item{df}{A data.frame to write.}

\item{file}{Character scalar. Path to output file.}

\item{tabular}{Logical. If TRUE (default), write as tabular TOON array.}

\item{pretty}{Logical. If TRUE (default), use multi-line formatting.}

\item{indent}{Integer. Number of spaces for indentation (default 2).}

\item{strict}{Logical. If TRUE (default), reject NaN/Inf values.}
}
\value{
Invisibly returns NULL.
}
\description{
Write data.frame to tabular TOON
}
\examples{
\dontrun{
# Write data.frame as tabular TOON
write_toon_df(mtcars[1:3, 1:4], "cars.toon")
}

}
