% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-headers.R
\name{preprocess_header}
\alias{preprocess_header}
\title{Run the C preprocessor on \code{file} using the provided compiler}
\usage{
preprocess_header(file, cc = r_cc(), ccflags = NULL, ...)
}
\arguments{
\item{file}{Path to a header file to preprocess.}

\item{cc}{(Character) Compiler command to use. If \code{NULL}, resolved via \code{r_cc()}.}

\item{ccflags}{(Character) Additional flags to pass to the compiler.}

\item{...}{
  Arguments passed on to \code{\link[=preprocess_headers]{preprocess_headers}}
  \describe{
    \item{\code{dir}}{Directory where header files will be searched.}
    \item{\code{recursive}}{Logical; whether to search recursively.}
    \item{\code{pattern}}{File name pattern(s) used to identify header files.}
  }}
}
\value{
Character scalar with the preprocessed output of \code{file}.
}
\description{
This function runs the configured C compiler with the \code{-E} preprocessor
flag and returns the combined preprocessed output as a single string.
}
\examples{
\dontrun{
# Check for a compiler before running an example that invokes the preprocessor
rcc <- treesitter.c::r_cc()
if (nzchar(rcc)) {
  rcc_prog <- strsplit(rcc, "\\\\s+")[[1]][1]
  if (nzchar(Sys.which(rcc_prog))) {
    tmp <- tempfile("hdr3")
    dir.create(tmp)
    path <- file.path(tmp, "p.h")
    writeLines(c("#define TYPE int", "TYPE foo(TYPE x);"), path)
    out <- preprocess_header(path)
    grepl("int foo\\\\(", out)
  } else {
    message("Skipping preprocess example: compiler not found on PATH")
  }
}
}
}
