% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kmdiff}
\alias{kmdiff}
\title{Estimate of Milestone Survival Difference}
\usage{
kmdiff(
  data,
  stratum = "",
  treat = "treat",
  time = "time",
  time2 = "",
  event = "event",
  weight = "",
  milestone = 0,
  survDiffH0 = 0,
  conflev = 0.95
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{stratum}: The stratum.
\item \code{treat}: The treatment.
\item \code{time}: The follow-up time for right censored data, or
the left end of each interval for counting process data.
\item \code{time2}: The right end of each interval for counting process
data. Intervals are assumed to be open on the left
and closed on the right, and event indicates whether an event
occurred at the right end of each interval.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{weight}: The weight for each observation.
}}

\item{stratum}{The name of the stratum variable in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{time}{The name of the time variable or the left end of each
interval for counting process data in the input data.}

\item{time2}{The name of the right end of each interval for counting
process data in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{weight}{The name of the weight variable in the input data.}

\item{milestone}{The milestone time at which to calculate the
survival probability.}

\item{survDiffH0}{The difference in milestone survival probabilities
under the null hypothesis. Defaults to 0 for superiority test.}

\item{conflev}{The level of the two-sided confidence interval for
the difference in milestone survival probabilities. Defaults to 0.95.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{milestone}: The milestone time relative to randomization.
\item \code{survDiffH0}: The difference in milestone survival probabilities
under the null hypothesis.
\item \code{surv1}: The estimated milestone survival probability for
the treatment group.
\item \code{surv2}: The estimated milestone survival probability for
the control group.
\item \code{survDiff}: The estimated difference in milestone survival
probabilities.
\item \code{vsurv1}: The variance for surv1.
\item \code{vsurv2}: The variance for surv2.
\item \code{sesurvDiff}: The standard error for survDiff.
\item \code{survDiffZ}: The Z-statistic value.
\item \code{survDiffPValue}: The two-sided p-value.
\item \code{lower}: The lower bound of confidence interval.
\item \code{upper}: The upper bound of confidence interval.
\item \code{conflev}: The level of confidence interval.
}
}
\description{
Obtains the estimate of milestone survival difference
between two treatment groups.
}
\examples{

kmdiff(data = rawdata[rawdata$iterationNumber == 1, ],
       stratum = "stratum", treat = "treatmentGroup",
       time = "timeUnderObservation", event = "event",
       milestone = 12)
             
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
