% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_awareness.R
\name{ts_aug_awareness}
\alias{ts_aug_awareness}
\title{Augmentation by Awareness}
\usage{
ts_aug_awareness(factor = 1)
}
\arguments{
\item{factor}{Numeric factor controlling the recency weighting.}
}
\value{
A \code{ts_aug_awareness} object.
}
\description{
Bias the augmentation to emphasize more recent points in each
window (recency awareness), increasing their contribution to the augmented
sample.
}
\examples{
# Recency-aware augmentation over sliding windows
# Load package and example dataset
library(daltoolbox)
data(tsd)

# Convert to 10-lag sliding windows and preview
xw <- ts_data(tsd$y, 10)
ts_head(xw)

# Apply awareness augmentation (bias toward recent rows)
augment <- ts_aug_awareness()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
\references{
\itemize{
\item Q. Wen et al. (2021). Time Series Data Augmentation for Deep Learning:
A Survey. IJCAI Workshop on Time Series.
}
}
