% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{fertilizers}
\alias{fertilizers}
\title{FAOSTAT Fertilizers by Nutrient}
\format{
A list of time series.
}
\source{
\href{https://www.fao.org/faostat/en/#data/RFN}{FAOSTAT Fertilizers by Nutrient}.
}
\usage{
data(fertilizers)
}
\description{
Statistics on agricultural use, production, and trade of chemical and mineral fertilizers.
Data Type:	Fertilizers use, production and trade. Category:	Environment. Creation Date	2024.
}
\examples{
# Load fertilizers list and plot one series
data(fertilizers)
# fertilizers <- loadfulldata(fertilizers)
series <- fertilizers[[1]]
ts.plot(series, ylab = "tonnes", xlab = "Year", main = "Fertilizers example")
}
\references{
FAO, 2024. FAOSTAT: Fertilizers by Nutrient.
FAO & UNSD (2017). System of Environmental-Economic Accounting for Agriculture, Forestry and Fisheries (SEEA AFF).
UNSD (2017). Framework for the Development of Environment Statistics (FDES).
}
\keyword{datasets}
