% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_inc.R
\name{plot_inc}
\alias{plot_inc}
\title{Plot estimated cumulative incidence functions (CIFs)}
\usage{
plot_inc(
  fit,
  decrease = FALSE,
  conf.int = 0.95,
  xlab = "Time",
  xlim = NULL,
  ylim = c(0, 1),
  plot.configs = list(ylab = NULL, main = NULL, lty = 1, lwd = 2, ci.lty = 5, ci.lwd =
    1.5, legend = c("Treated", "Control"), col = c("brown", "darkcyan"), legend.cex =
    0.9, show.p.value = TRUE),
  ...
)
}
\arguments{
\item{fit}{A fitted object returned by the function \code{tteICE}, \code{surv.tteICE}, or \code{scr.tteICE}.}

\item{decrease}{A logical variable indicating the type of curve to display.
If \code{decrease = FALSE} (default), cumulative incidence functions (CIFs) are plotted.
If \code{decrease = TRUE}, survival functions are plotted instead.}

\item{conf.int}{Confidence level for the pointwise confidence intervals
If \code{conf.int = NULL}, no confidence intervals are provided.}

\item{xlab}{Label for the x-axis.}

\item{xlim}{A numeric vector of length 2 specifying the limits of the x-axis.
If \code{xlim = NULL} (default), the limits are determined automatically from the data.}

\item{ylim}{A numeric vector of length 2 specifying the limits of the y-axis.
Defaults to \code{ylim = c(0, 1)}.}

\item{plot.configs}{A named \code{list} of additional plot configurations. Common entries include:

\itemize{
\item \code{ylab}: character, label for the y-axis (default: \code{ylab=NULL}, use the default label).
\item \code{main}: character, title for the plot (default: \code{main=NULL}, use the default label).
\item \code{lty}: line type for the curve (default: \code{lty=1}).
\item \code{lwd}: line width for the curve (default: \code{lwd=2}).
\item \code{ci.lty}: line type for confidence interval curves (default: \code{ci.lty=5, ci.lwd=1.5}).
\item \code{ci.lwd}: line width for confidence interval curves (default: \code{ci.lwd=1.5}).
\item \code{legend}: legend for the two group (default: \code{legend=c('Treated','Control')}).
\item \code{col}: color of the curve for the two group (default: \code{col=c('brown','darkcyan')}).
\item \code{legend.cex}: font size for the legend (default: \code{legend.cex=0.9}).
\item \code{show.p.value}: whether to show the p-value between two groups (default: \code{show.p.value=TRUE}, show the p-value)
}}

\item{...}{Additional graphical arguments passed to function \code{\link{plot.default}} or function \code{\link{curve}}}
}
\value{
Plot the cumulative incidence function results from a tteICE object
}
\description{
This function plots the estimated potential cumulative incidence function, along with pointwise confidence intervals.
}
\examples{
## load data
data(bmt)
bmt = transform(bmt, d4=d2+d3)
A = as.numeric(bmt$group>1)
bmt$A = A

## simple model fitting and plotting
library(survival)
fit = tteICE(Surv(t2,d4,type = "mstate")~A, data=bmt)
plot_inc(fit)

## model fitting using competing risk data
fit1 = surv.tteICE(A, bmt$t2, bmt$d4, 'treatment')

## plot asymptotic confidence intervals based on explicit formulas
plot_inc(fit1, ylim=c(0,1),
         plot.configs=list(legend=c('AML','ALL'), show.p.value=FALSE) )

## plot bootstrap confidence intervals
fit2 = surv.tteICE(A, bmt$t2, bmt$d4, 'treatment', nboot=50)
plot_inc(fit2, ylim=c(0,1),
         plot.configs=list(legend=c('AML','ALL')))

## model fitting using semicompeting risk data
fit3 = scr.tteICE(A, bmt$t1, bmt$d1, bmt$t2, bmt$d2, "composite")

## plot asymptotic confidence intervals based on explicit formulas
plot_inc(fit3, ylim=c(0,1), plot.configs=list(add.null.line=FALSE))

## plot bootstrap confidence intervals
fit4 = scr.tteICE(A, bmt$t1, bmt$d1, bmt$t2, bmt$d2,
                  "composite", nboot=50) ##??
plot_inc(fit4, ylim=c(0,1),
         plot.configs=list(lty=2, lwd=3, main="My title"))

}
\seealso{
\code{\link[graphics]{plot.default}},
\code{\link[graphics]{points}},
\code{\link[graphics]{curve}},
\code{\link[tteICE]{plot.tteICE}}
}
