##' Wine Chemical Analysis Data (Binary Cultivar)
##'
##' The well-known wine dataset comprises the results of chemical analyses of 178 wines
##' produced in the same region of Italy from three grape varieties (Barolo, Grignolino,
##' and Barbera). The dataset was originally introduced by Forina et al. (1984) and later
##' described in detail by Forina et al. (1986).
##'
##' For each sample, 13 continuous chemical constituents were measured, which serve as
##' covariates for distinguishing between the grape varieties. For the analyses in this
##' package, a version of the dataset with a binary outcome is provided that differentiates
##' between Grignolino (\code{"G"}) and the two other varieties (\code{"Other"}; Barolo and Barbera).
##' This version is available on OpenML under data ID 973.
##'
##' The variables are as follows:
##' \itemize{
##'   \item \code{Alc}. numeric. Alcohol.
##'   \item \code{Mal}. numeric. Malic acid.
##'   \item \code{Ash}. numeric. Ash.
##'   \item \code{AlcAsh}. numeric. Alkalinity of ash.
##'   \item \code{Mg}. numeric. Magnesium.
##'   \item \code{TP}. numeric. Total phenols.
##'   \item \code{Fla}. numeric. Flavonoids.
##'   \item \code{NFP}. numeric. Nonflavonoid phenols.
##'   \item \code{ProAn}. numeric. Proanthocyanins.
##'   \item \code{Col}. numeric. Color intensity.
##'   \item \code{Hue}. numeric. Hue.
##'   \item \code{WAI}. numeric. OD280/OD315 of diluted wines (wine absorbance index).
##'   \item \code{Prol}. numeric. Proline.
##'   \item \code{C}. factor. Cultivar. Binary target variable: \code{"G"} vs \code{"Other"}.
##' }
##'
##' @format A data frame with 178 observations, 13 numeric covariates and one binary target variable.
##' @source OpenML: data.id: 973, link: \url{https://www.openml.org/d/973/}
##'
##' @examples
##' data(wine)
##'
##' table(wine$C)
##' dim(wine)
##'
##' head(wine)
##'
##' @references
##' \itemize{
##'   \item Forina, M. (1984). PARVUS, TrAC Trends in Analytical Chemistry, 3(2):38–39, <\doi{10.1016/0165-9936(84)87050-8}>.
##'   \item Forina, M., Armanino, C., Castino, M., Ubigli, M. (1986). Multivariate data analysis as a discriminating method of the origin of wines, Vitis, 25:189--201, <\doi{10.5073/vitis.1986.25.189-201}>.
##'   \item Vanschoren, J., van Rijn, J. N., Bischl, B., Torgo, L. (2013). OpenML: networked science in machine learning. SIGKDD Explorations, 15(2):49--60, <\doi{10.1145/2641190.2641198}>.
##' }
##'
##' @name wine
NULL
