% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_needed_to_vaccinate.R
\name{compute_number_needed_to_vaccinate_tuite_fisman}
\alias{compute_number_needed_to_vaccinate_tuite_fisman}
\title{Compute the number of individuals needed to vaccinate to prevent
one event according to Tuite and Fisman method}
\usage{
compute_number_needed_to_vaccinate_tuite_fisman(
  number_of_vaccinated,
  number_of_events_averted
)
}
\arguments{
\item{number_of_vaccinated}{number of vaccinated individuals}

\item{number_of_events_averted}{number of events averted}
}
\value{
The number of individuals needed to vaccinate to avert
one event
}
\description{
Compute the number of individuals needed to vaccinate to prevent
one event according to Tuite and Fisman method
}
\details{
The number of individuals needed to vaccinate to prevent one event is calculated as described by Tuite and Fisman (2013) \url{doi:10.1016/j.vaccine.2012.11.097}.
}
\examples{
data(coverage_and_incidence_mock_data)
data(ve_mock_data)
coverage <- coverage_and_incidence_mock_data$coverage_data
incidence <- coverage_and_incidence_mock_data$incidence_data
vaccine_effectiveness <- ve_mock_data$ve
nae <- compute_events_averted_by_vaccination(
  number_of_events = incidence$events,
  cumulative_coverage = coverage$cumulative_coverage,
  vaccine_effectiveness = vaccine_effectiveness
)
nnv_tuite_fisman <- compute_number_needed_to_vaccinate_tuite_fisman(
  number_of_vaccinated = coverage$number_of_vaccinated,
  number_of_events_averted = nae
)
nnv_tuite_fisman
}
