% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plot_vald_compare}
\alias{plot_vald_compare}
\title{Boxplot Comparison of Metrics by Sport, Sex, or Team}
\usage{
plot_vald_compare(
  data,
  metric_col,
  group_col = "sports",
  fill_col = "sex",
  title = NULL,
  y_label = NULL
)
}
\arguments{
\item{data}{Data frame. Test data with grouping variables and metrics.}

\item{metric_col}{Character. Name of the metric to plot.}

\item{group_col}{Character. Primary grouping variable (x-axis).
Default is "sports".}

\item{fill_col}{Character. Optional fill color grouping (e.g., "sex").
Default is "sex".}

\item{title}{Character. Plot title. If NULL, auto-generates from metric name.}

\item{y_label}{Character. Y-axis label. If NULL, uses metric_col.}
}
\value{
A ggplot2 object.
}
\description{
Creates boxplots to compare performance metrics across different groups
(e.g., sports, sex, teams). Useful for benchmarking and identifying
performance differences between populations.
}
\details{
Compare Performance Across Groups
}
\examples{
\donttest{
if (FALSE) {
  test_datasets <- split_by_test(final_analysis_data)

  # Compare CMJ peak force across sports and sex
  plot_vald_compare(
    data = test_datasets$CMJ,
    metric_col = "PEAK_FORCE_Both",
    group_col = "sports",
    fill_col = "sex",
    title = "Peak Force Comparison by Sport and Sex"
  )
}
}
}
