% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate_triple_general.R
\name{integrate_triple_general}
\alias{integrate_triple_general}
\title{Numerical Triple Integration over a General Region}
\usage{
integrate_triple_general(
  f,
  x_min,
  x_max,
  y_limit1,
  y_limit2,
  z_limit1,
  z_limit2,
  n_outer = 50,
  n_middle = 50,
  n_inner = 50,
  plot_xy_domain = TRUE
)
}
\arguments{
\item{f}{A function in R of three variables, \code{f(x, y, z)}, returning a numeric value.}

\item{x_min}{The constant lower limit for the outermost integral (x = a).}

\item{x_max}{The constant upper limit for the outermost integral (x = b).}

\item{y_limit1}{A function in R of one variable defining the middle integral's lower limit (y = h1(x)).}

\item{y_limit2}{A function in R of one variable defining the middle integral's upper limit (y = h2(x)).}

\item{z_limit1}{A function in R of two variables defining the inner integral's lower limit (z = g1(x, y)).}

\item{z_limit2}{A function in R of two variables defining the inner integral's upper limit (z = g2(x, y)).}

\item{n_outer}{Number of subintervals for the outermost integral (x). Must be even. Default is 50.}

\item{n_middle}{Number of subintervals for the middle integral (y). Must be even. Default is 50.}

\item{n_inner}{Number of subintervals for the innermost integral (z). Must be even. Default is 50.}

\item{plot_xy_domain}{Logical. If TRUE, generates a ggplot2 plot of the projection
of the domain W onto the xy-plane. Default is TRUE.}
}
\value{
A list containing:
\itemize{
\item \code{integral_value}: The calculated approximation of the integral.
\item \code{domain_plot}: The ggplot2 object representing the xy-projection domain
(if \code{plot_xy_domain = TRUE}).
}
}
\description{
Calculates the definite triple integral of a function f(x, y, z) over a
general region W defined by the order dz dy dx.
The region W is defined by constant limits for the outer integral (x),
functional limits depending on x for the middle integral (y), and
functional limits depending on both x and y for the inner integral (z).
Uses the Composite Simpson's Rule for numerical approximation.
}
