% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surface_with_tangents.R
\name{plot_surface_with_tangents}
\alias{plot_surface_with_tangents}
\title{Surface with tangent lines at a point}
\usage{
plot_surface_with_tangents(
  f,
  x0,
  y0,
  xlim = c(-3, 3),
  ylim = c(-3, 3),
  n = 120,
  h = 1e-05,
  t_len = 0.75,
  title_prefix = "f"
)
}
\arguments{
\item{f}{Scalar field, given as \code{function(x, y)} returning a numeric
value.}

\item{x0, y0}{Numeric scalars with the coordinates of the point where
the tangent lines are drawn.}

\item{xlim}{Numeric vector \code{c(x_min, x_max)} giving the range of the
\eqn{x}-axis used to draw the surface.}

\item{ylim}{Numeric vector \code{c(y_min, y_max)} giving the range of the
\eqn{y}-axis used to draw the surface.}

\item{n}{Integer number of grid points per axis used to discretize the
surface. Must be at least 20.}

\item{h}{Numeric step used for the central finite–difference
approximation of the partial derivatives \eqn{f_x} and \eqn{f_y}.}

\item{t_len}{Numeric scalar giving half the length of the tangent
segments along the \eqn{x} and \eqn{y} directions.}

\item{title_prefix}{Optional character string used as a prefix in the
plot title (for example, the name of the function \eqn{f}).}
}
\value{
A \pkg{plotly} object representing the surface \eqn{z = f(x, y)} together
with the point \eqn{(x_0, y_0, f(x_0, y_0))} and the two tangent line
segments. The object can be further modified with usual \pkg{plotly}
tools.
}
\description{
Draws the surface \eqn{z = f(x, y)} on a rectangular domain and overlays
two tangent line segments at a given point \eqn{(x_0, y_0)}:
one tangent in the direction of the \eqn{x}-axis and one tangent in the
direction of the \eqn{y}-axis. The partial derivatives are approximated
numerically by central finite differences.
}
\examples{
\dontshow{if (interactive()) \{}
f <- function(x, y) sin(x) * cos(y)
p <- plot_surface_with_tangents(
  f,
  x0 = 1, y0 = 1,
  xlim = c(-3, 3),
  ylim = c(-3, 3),
  n = 80
)
# p
\dontshow{\}}

}
