% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riemann_prisms3d.R
\name{riemann_prisms3d}
\alias{riemann_prisms3d}
\title{Riemann rectangular prisms over a planar region}
\usage{
riemann_prisms3d(
  f,
  f1,
  f2,
  a,
  b,
  N,
  M,
  plot = TRUE,
  estimate = c("lower", "upper", "mean", "all"),
  sample_n = 6,
  show_surface = FALSE,
  surface_colorscale = "Viridis",
  surface_opacity = 0.35,
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  color_by = c("mean", "lower", "upper"),
  top_colorscale = "YlOrBr",
  top_opacity = 0.85,
  side_color = "rgba(60,60,60,0.25)",
  side_opacity = 0.35,
  frame_color = "rgba(0,0,0,0.55)",
  frame_width = 1.5,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{f}{A function \code{f(x, y)} returning a numeric scalar.}

\item{f1, f2}{Functions returning the lower and upper y-boundaries for each x.
The valid y-range at each x is the interval between the minimum and maximum
of these two functions.}

\item{a, b}{Numeric endpoints of the x-interval. Must satisfy \code{a < b}.}

\item{N, M}{Integer numbers of subdivisions in x and y for the rectangular
partition.}

\item{plot}{Logical. If \code{TRUE}, the 3D visualization is generated.}

\item{estimate}{Character. One of \code{"lower"}, \code{"upper"},
\code{"mean"}, or \code{"all"}, indicating which estimate to highlight.}

\item{sample_n}{Integer. Number of evaluation points per direction inside
each cell when computing lower, upper, and mean values.}

\item{show_surface}{Logical. If \code{TRUE}, draws the surface
\code{z = F(x, y)} over the entire rectangular bounding box.}

\item{surface_colorscale}{Colorscale used for the surface.}

\item{surface_opacity}{Opacity for the surface.}

\item{show_surface_grid}{Logical. If \code{TRUE}, draws a grid on the surface.}

\item{surface_grid_color}{Color of the grid lines.}

\item{surface_grid_width}{Width of the grid lines.}

\item{color_by}{Character. Determines the value used to color the top of
each prism: \code{"mean"}, \code{"lower"}, or \code{"upper"}.}

\item{top_colorscale}{Colorscale for the prism tops.}

\item{top_opacity}{Opacity of the prism tops.}

\item{side_color}{Color for the vertical faces of the prisms.}

\item{side_opacity}{Opacity of the prism sides.}

\item{frame_color}{Color for the prism frame lines.}

\item{frame_width}{Width of the frame lines.}

\item{scene}{A list with plotly 3D scene settings.}

\item{bg}{A list with background colors for the figure.}
}
\value{
A list containing:
\describe{
\item{\code{sum_lower}}{Lower Riemann sum for the chosen partition.}
\item{\code{sum_upper}}{Upper Riemann sum.}
\item{\code{sum_mean}}{Mean-value Riemann sum.}
\item{\code{cells}}{A tibble describing all valid cells.}
\item{\code{fig}}{A \pkg{plotly} object if \code{plot = TRUE}, otherwise \code{NULL}.}
\item{\code{estimate}}{When \code{estimate != "all"}, the selected
Riemann sum (lower/upper/mean) is repeated here for convenience.}
}
}
\description{
Approximates the double integral of a scalar function over a planar region
using an N-by-M rectangular partition and rectangular prisms with constant
height on each cell. The region is defined by an x-interval and two functions
giving the lower and upper y-limits. Each valid cell produces a prism whose
height corresponds to a chosen estimate of the function on that cell:
lower value, upper value, or mean value.

When \code{plot = TRUE}, a 3D visualization of the prisms is produced using
\pkg{plotly}. Optionally, the actual surface \code{z = F(x, y)} can also be
drawn over the rectangular bounding box that contains the region.
}
\examples{
f  <- function(x, y) x * y
f1 <- function(x) 0
f2 <- function(x) 1 - x
riemann_prisms3d(f, f1, f2, 0, 1, N = 10, M = 10, plot = FALSE)

}
