% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solid_spherical3d.R
\name{solid_spherical3d}
\alias{solid_spherical3d}
\title{Solid in spherical coordinates with Plotly visualization and volume}
\usage{
solid_spherical3d(
  R1,
  R2,
  theta_range = c(0, 2 * pi),
  phi_range = c(0, pi),
  n_theta = 160,
  n_phi = 120,
  plot = TRUE,
  show_surfaces = c(TRUE, TRUE),
  colorscales = list("Blues", "Reds"),
  opacities = c(0.3, 0.35),
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white"),
  compute_volume = FALSE,
  vol_method = c("adaptive", "grid"),
  n_th_vol = 600,
  n_ph_vol = 400
)
}
\arguments{
\item{R1, R2}{Functions \code{function(theta, phi)} giving the inner and outer
radius, respectively, as numeric scalars.}

\item{theta_range}{Numeric vector of length 2, \code{c(theta_min, theta_max)},
giving the azimuth interval in radians.}

\item{phi_range}{Numeric vector of length 2, \code{c(phi_min, phi_max)},
giving the polar angle interval in radians.}

\item{n_theta, n_phi}{Mesh resolution for the two boundary surfaces. Each
surface is sampled on an \code{n_phi x n_theta} grid.}

\item{plot}{Logical. If \code{TRUE}, the solid boundaries are drawn with
\pkg{plotly}.}

\item{show_surfaces}{Logical vector of length 2 indicating which spherical
shells to show in the plot, in the order \code{c(r = R1, r = R2)}.}

\item{colorscales}{Colorscales for the two surfaces. You can pass:
\itemize{
\item a single Plotly colorscale (string, single color, or vector
of colors) applied to both surfaces, or
\item a list of length 2, with one colorscale per surface.
}
Flat colors such as \code{"#2a9d8f"} or \code{"rgba(0,0,0,0.6)"} are
also accepted.}

\item{opacities}{Numeric vector of length 1 or 2 giving the opacity of the
two surfaces.}

\item{show_surface_grid}{Logical. If \code{TRUE}, draws grid lines on the
surfaces.}

\item{surface_grid_color, surface_grid_width}{Color and width for the surface
grid lines.}

\item{scene}{Plotly 3D scene settings. By default the aspect mode is
\code{"data"} and each axis has a title.}

\item{bg}{Background colors, typically a list of the form
\code{list(paper = "white", plot = "white")}.}

\item{compute_volume}{Logical. If \code{TRUE}, the volume of the solid is
approximated numerically using the spherical volume integral.}

\item{vol_method}{Character string indicating the integration method for
the volume: \code{"adaptive"} uses nested \code{stats::integrate},
while \code{"grid"} uses the trapezoidal rule on a regular grid.}

\item{n_th_vol, n_ph_vol}{Integer resolutions for the grid method in the
azimuth and polar directions, respectively (ignored when
\code{vol_method = "adaptive"}).}
}
\value{
A list with:
\itemize{
\item \code{theta_seq}, \code{phi_seq}: the parameter sequences used for
plotting,
\item \code{R1_surf}, \code{R2_surf}: lists containing the matrices
\code{X}, \code{Y}, \code{Z} for the two boundary surfaces
(or \code{NULL} if the corresponding surface is not shown),
\item \code{fig}: a \pkg{plotly} figure when \code{plot = TRUE},
otherwise \code{NULL},
\item \code{volume}: \code{NULL} if \code{compute_volume = FALSE},
or a list with the numeric volume estimate, the method used and
additional metadata when \code{compute_volume = TRUE}.
}
}
\description{
Draws a three-dimensional solid described in spherical coordinates by:
\itemize{
\item a radial variable \code{r} between \code{R1(theta, phi)} and
\code{R2(theta, phi)},
\item an azimuthal angle \code{theta} in the interval
\code{[theta_range[1], theta_range[2]]} (in radians),
\item a polar angle \code{phi} in the interval
\code{[phi_range[1], phi_range[2]]} (in radians).
}

The function uses the standard convention for spherical coordinates:
\code{theta} is the azimuth (angle in the xy-plane) and \code{phi} is the
polar angle measured from the positive z-axis.

Optionally, the volume of the solid is computed using the spherical volume
element. The exact integral has the form:
\itemize{
\item inner integral: from \code{r = R1(theta, phi)} to \code{r = R2(theta, phi)}
of \code{r^2 * sin(phi) dr},
\item outer integrals: over \code{phi} in \code{[phi_min, phi_max]} and
\code{theta} in \code{[theta_min, theta_max]}.
}
Equivalently, for each pair \code{(theta, phi)} one integrates
\code{(R2(theta, phi)^3 - R1(theta, phi)^3) / 3 * sin(phi)} over the angular
rectangle.
}
\examples{
\dontshow{if (interactive()) \{}
# Example 1: Spherical shell: a <= r <= b, independent of angles
R1 <- function(th, ph) 0.8
R2 <- function(th, ph) 1.2
out <- solid_spherical3d(
  R1, R2,
  theta_range = c(0, 2*pi),
  phi_range   = c(0, pi),
  plot = TRUE,
  colorscales = list("Blues", "Reds"),
  opacities   = c(0.25, 0.35),
  compute_volume = TRUE
)
out$volume$estimate       # approximately 4/3 * pi * (1.2^3 - 0.8^3)

# Example 2: Spherical cap: 0 <= r <= 1, phi in [0, pi/3]
R1 <- function(th, ph) 0
R2 <- function(th, ph) 1
out2 <- solid_spherical3d(
  R1, R2,
  theta_range = c(0, 2*pi),
  phi_range   = c(0, pi/3),
  plot = TRUE,
  compute_volume = TRUE
)
out2$volume$estimate      # analytic value matches the standard spherical cap formula
\dontshow{\}}

}
