% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tangent_plane3d.R
\name{tangent_plane3d}
\alias{tangent_plane3d}
\title{Tangent plane and normal vector to a surface z = f(x, y)}
\usage{
tangent_plane3d(
  f,
  point,
  h = 1e-04,
  plot = FALSE,
  x_window = 4,
  y_window = 4,
  z_window = 4,
  grid = 50,
  plane_window = 1,
  vec_N_factor = 1,
  surface_opacity = 0.85,
  plane_opacity = 0.7,
  colors = list(surface = "Viridis", plane = "Reds", xcut = "black", ycut = "black",
    point = "blue", normal = "red"),
  show_surface_grid = FALSE,
  surface_grid_color = "rgba(0,0,0,0.35)",
  surface_grid_width = 1,
  show_axis_grid = TRUE,
  axis_grid_color = "#e5e5e5",
  axis_grid_width = 1,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{f}{Function of two variables \code{f(x, y)} returning a numeric
scalar, representing the height \code{z}.}

\item{point}{Numeric vector of length 2 giving the point of tangency
\code{c(x0, y0)}.}

\item{h}{Numeric step used in the centered finite-difference
approximation of the partial derivatives. Must be strictly positive.}

\item{plot}{Logical; if \code{TRUE}, constructs a \pkg{plotly} figure
with the surface, tangent plane, cross-sections and normal vector.}

\item{x_window}{Numeric half-width of the window in the \code{x}
direction used to draw the surface patch.}

\item{y_window}{Numeric half-width of the window in the \code{y}
direction used to draw the surface patch.}

\item{z_window}{Numeric half-height for the visible \code{z} range
around \code{f(x0, y0)}.}

\item{grid}{Integer number of grid points used to sample the surface
in each horizontal direction.}

\item{plane_window}{Numeric half-width of the square patch of the
tangent plane drawn around \code{(x0, y0)}.}

\item{vec_N_factor}{Numeric scale factor applied to the unit normal
vector when drawing the segment that represents the normal.}

\item{surface_opacity}{Numeric value between 0 and 1 controlling the
opacity of the surface patch.}

\item{plane_opacity}{Numeric value between 0 and 1 controlling the
opacity of the tangent-plane patch.}

\item{colors}{List with named entries that control colors in the plot:
\itemize{
\item \code{surface}: colorscale for the original surface,
\item \code{plane}: colorscale for the tangent plane,
\item \code{xcut}: color for the intersection curve along
\code{y = y0},
\item \code{ycut}: color for the intersection curve along
\code{x = x0},
\item \code{point}: color for the tangency point marker,
\item \code{normal}: color for the normal vector segment.
}}

\item{show_surface_grid}{Logical; if \code{TRUE}, draws a grid on the
surface patch.}

\item{surface_grid_color, surface_grid_width}{Color and width of the
surface grid lines.}

\item{show_axis_grid}{Logical; if \code{TRUE}, draws grid lines on the
coordinate axes in the 3D scene.}

\item{axis_grid_color, axis_grid_width}{Color and width of the axis
grid lines.}

\item{scene}{List with 3D scene options passed to \code{plotly::layout},
typically including axis titles and \code{aspectmode}.}

\item{bg}{List with background colors for the figure, with fields
\code{paper} and \code{plot}.}
}
\value{
A list with components:
\itemize{
\item \code{fx}, \code{fy}: approximations of the partial derivatives
\code{f_x(x0, y0)} and \code{f_y(x0, y0)},
\item \code{f0}: value \code{f(x0, y0)},
\item \code{normal_unit}: unit normal vector at the point of tangency,
\item \code{normal_raw}: non-normalized normal vector
\code{(-fx, -fy, 1)},
\item \code{plane_fun}: function \code{g(x, y)} for the tangent plane,
\item \code{plane_coeff}: numeric vector \code{c(a, b, c, d)} such that
\code{a x + b y + c z + d = 0} is the tangent-plane equation,
\item \code{fig}: a \pkg{plotly} figure when \code{plot = TRUE},
otherwise \code{NULL}.
}
}
\description{
Computes the tangent plane to the graph of a scalar field \code{z = f(x, y)}
at a given point \code{(x0, y0)}, together with the associated normal
vector. Optionally, it displays the surface, the tangent plane, two
orthogonal cross-sections and the normal vector using \pkg{plotly}.
}
\details{
Given a differentiable function \code{f(x, y)} and a point
\code{(x0, y0)}, the function:
\itemize{
\item approximates the partial derivatives \code{f_x(x0, y0)} and
\code{f_y(x0, y0)} using centered finite differences with step
\code{h},
\item builds the tangent plane
\code{g(x, y) = f(x0, y0) + f_x(x0, y0) * (x - x0) + f_y(x0, y0) * (y - y0)},
\item constructs a normal vector \code{n = (-f_x, -f_y, 1)} and its
unit version,
\item encodes the plane in the form \code{a x + b y + c z + d = 0},
with the coefficients returned in \code{plane_coeff}.
}

When \code{plot = TRUE}, the function produces an interactive figure
containing:
\itemize{
\item a patch of the original surface,
\item a patch of the tangent plane centered at \code{(x0, y0)},
\item two intersection curves of the surface along \code{x = x0} and
\code{y = y0},
\item the point of tangency and a segment in the direction of the
normal vector.
}
}
\examples{
\dontshow{if (interactive()) \{}
f <- function(x, y) x^2 + y^2
tp <- tangent_plane3d(
  f,
  point = c(1, 1),
  plot = FALSE
)
tp$plane_coeff
\dontshow{\}}

}
